/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.keyvalue.helpers;

import java.io.File;
import org.apache.hadoop.ozone.shaded.com.google.common.base.Preconditions;

public final class KeyValueContainerLocationUtil {
    private KeyValueContainerLocationUtil() {
    }

    public static File getContainerMetaDataPath(String hddsVolumeDir, String scmId, long containerId) {
        String containerMetaDataPath = KeyValueContainerLocationUtil.getBaseContainerLocation(hddsVolumeDir, scmId, containerId);
        containerMetaDataPath = containerMetaDataPath + File.separator + "metadata";
        return new File(containerMetaDataPath);
    }

    public static File getChunksLocationPath(String baseDir, String scmId, long containerId) {
        String chunksPath = KeyValueContainerLocationUtil.getBaseContainerLocation(baseDir, scmId, containerId) + File.separator + "chunks";
        return new File(chunksPath);
    }

    private static String getBaseContainerLocation(String hddsVolumeDir, String scmId, long containerId) {
        Preconditions.checkNotNull(hddsVolumeDir, "Base Directory cannot be null");
        Preconditions.checkNotNull(scmId, "scmUuid cannot be null");
        Preconditions.checkState(containerId >= 0L, "Container Id cannot be negative.");
        String containerSubDirectory = KeyValueContainerLocationUtil.getContainerSubDirectory(containerId);
        String containerMetaDataPath = hddsVolumeDir + File.separator + scmId + File.separator + "current" + File.separator + containerSubDirectory + File.separator + containerId;
        return containerMetaDataPath;
    }

    private static String getContainerSubDirectory(long containerId) {
        int directory = (int)(containerId >> 9 & 0xFFL);
        return "containerDir" + directory;
    }

    public static File getContainerDBFile(File containerMetaDataPath, long containerID) {
        return new File(containerMetaDataPath, containerID + "-dn-container.db");
    }
}

