/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.keyvalue.helpers;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.function.ToLongFunction;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.StorageContainerException;
import org.apache.hadoop.ozone.common.ChunkBuffer;
import org.apache.hadoop.ozone.container.common.helpers.ChunkInfo;
import org.apache.hadoop.ozone.container.common.volume.VolumeIOStats;
import org.apache.hadoop.ozone.container.keyvalue.KeyValueContainerData;
import org.apache.hadoop.ozone.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.ozone.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ChunkUtils {
    private static final Set<Path> LOCKS = ConcurrentHashMap.newKeySet();
    private static final Logger LOG = LoggerFactory.getLogger(ChunkUtils.class);
    private static final Set<? extends OpenOption> WRITE_OPTIONS = Collections.unmodifiableSet(EnumSet.of(StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.SPARSE));
    private static final Set<? extends OpenOption> READ_OPTIONS = Collections.unmodifiableSet(EnumSet.of(StandardOpenOption.READ));
    private static final FileAttribute<?>[] NO_ATTRIBUTES = new FileAttribute[0];

    private ChunkUtils() {
    }

    public static void writeData(File file, ChunkBuffer data, long offset, long len, VolumeIOStats volumeIOStats, boolean sync) throws StorageContainerException {
        ChunkUtils.writeData(data, file.getName(), offset, len, volumeIOStats, (ChunkBuffer d) -> ChunkUtils.writeDataToFile(file, d, offset, sync));
    }

    public static void writeData(FileChannel file, String filename, ChunkBuffer data, long offset, long len, VolumeIOStats volumeIOStats) throws StorageContainerException {
        ChunkUtils.writeData(data, filename, offset, len, volumeIOStats, (ChunkBuffer d) -> ChunkUtils.writeDataToChannel(file, d, offset));
    }

    private static void writeData(ChunkBuffer data, String filename, long offset, long len, VolumeIOStats volumeIOStats, ToLongFunction<ChunkBuffer> writer) throws StorageContainerException {
        long bytesWritten;
        ChunkUtils.validateBufferSize(len, data.remaining());
        long startTime = Time.monotonicNow();
        try {
            bytesWritten = writer.applyAsLong(data);
        }
        catch (UncheckedIOException e) {
            throw ChunkUtils.wrapInStorageContainerException(e.getCause());
        }
        long endTime = Time.monotonicNow();
        long elapsed = endTime - startTime;
        volumeIOStats.incWriteTime(elapsed);
        volumeIOStats.incWriteOpCount();
        volumeIOStats.incWriteBytes(bytesWritten);
        LOG.debug("Written {} bytes at offset {} to {} in {} ms", new Object[]{bytesWritten, offset, filename, elapsed});
        ChunkUtils.validateWriteSize(len, bytesWritten);
    }

    private static long writeDataToFile(File file, ChunkBuffer data, long offset, boolean sync) {
        Path path = file.toPath();
        return ChunkUtils.processFileExclusively(path, () -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
    }

    private static long writeDataToChannel(FileChannel channel, ChunkBuffer data, long offset) {
        try {
            channel.position(offset);
            return data.writeTo(channel);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void readData(File file, ByteBuffer buf, long offset, long len, VolumeIOStats volumeIOStats) throws StorageContainerException {
        long bytesRead;
        Path path = file.toPath();
        long startTime = Time.monotonicNow();
        try {
            bytesRead = ChunkUtils.processFileExclusively(path, () -> {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }).intValue();
        }
        catch (UncheckedIOException e) {
            throw ChunkUtils.wrapInStorageContainerException(e.getCause());
        }
        long endTime = Time.monotonicNow();
        volumeIOStats.incReadTime(endTime - startTime);
        volumeIOStats.incReadOpCount();
        volumeIOStats.incReadBytes(bytesRead);
        LOG.debug("Read {} bytes starting at offset {} from {}", new Object[]{bytesRead, offset, file});
        ChunkUtils.validateReadSize(len, bytesRead);
        buf.flip();
    }

    public static boolean validateChunkForOverwrite(File chunkFile, ChunkInfo info) {
        if (ChunkUtils.isOverWriteRequested(chunkFile, info)) {
            if (!ChunkUtils.isOverWritePermitted(info)) {
                LOG.warn("Duplicate write chunk request. Chunk overwrite without explicit request. {}", (Object)info);
            }
            return true;
        }
        return false;
    }

    public static File getChunkFile(KeyValueContainerData containerData, ChunkInfo info) throws StorageContainerException {
        File chunksLoc = ChunkUtils.verifyChunkDirExists(containerData);
        return chunksLoc.toPath().resolve(info.getChunkName()).toFile();
    }

    public static File verifyChunkDirExists(KeyValueContainerData containerData) throws StorageContainerException {
        Preconditions.checkNotNull(containerData, "Container data can't be null");
        String chunksPath = containerData.getChunksPath();
        if (chunksPath == null) {
            LOG.error("Chunks path is null in the container data");
            throw new StorageContainerException("Unable to get Chunks directory.", ContainerProtos.Result.UNABLE_TO_FIND_DATA_DIR);
        }
        File chunksLoc = new File(chunksPath);
        if (!chunksLoc.exists()) {
            LOG.error("Chunks path does not exist");
            throw new StorageContainerException("Unable to get Chunks directory.", ContainerProtos.Result.UNABLE_TO_FIND_DATA_DIR);
        }
        return chunksLoc;
    }

    public static boolean isOverWriteRequested(File chunkFile, ChunkInfo chunkInfo) {
        if (!chunkFile.exists()) {
            return false;
        }
        long offset = chunkInfo.getOffset();
        return offset < chunkFile.length();
    }

    public static boolean isOverWritePermitted(ChunkInfo chunkInfo) {
        String overWrite = chunkInfo.getMetadata().get("OverWriteRequested");
        return Boolean.parseBoolean(overWrite);
    }

    @VisibleForTesting
    static <T> T processFileExclusively(Path path, Supplier<T> op) {
        while (!LOCKS.add(path)) {
        }
        try {
            T t = op.get();
            return t;
        }
        finally {
            LOCKS.remove(path);
        }
    }

    private static void closeFile(FileChannel file, boolean sync) {
        if (file != null) {
            try {
                if (sync) {
                    file.force(true);
                }
                file.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    private static void validateReadSize(long expected, long actual) throws StorageContainerException {
        ChunkUtils.checkSize("read", expected, actual, ContainerProtos.Result.CONTAINER_INTERNAL_ERROR);
    }

    private static void validateWriteSize(long expected, long actual) throws StorageContainerException {
        ChunkUtils.checkSize("write", expected, actual, ContainerProtos.Result.INVALID_WRITE_SIZE);
    }

    public static void validateBufferSize(long expected, long actual) throws StorageContainerException {
        ChunkUtils.checkSize("buffer", expected, actual, ContainerProtos.Result.INVALID_WRITE_SIZE);
    }

    private static void checkSize(String of, long expected, long actual, ContainerProtos.Result code) throws StorageContainerException {
        if (actual != expected) {
            String err = String.format("Unexpected %s size. expected: %d, actual: %d", of, expected, actual);
            LOG.error(err);
            throw new StorageContainerException(err, code);
        }
    }

    private static StorageContainerException wrapInStorageContainerException(IOException e) {
        ContainerProtos.Result result = ChunkUtils.translate(e);
        return new StorageContainerException(e, result);
    }

    private static ContainerProtos.Result translate(Exception cause) {
        if (cause instanceof FileNotFoundException || cause instanceof NoSuchFileException) {
            return ContainerProtos.Result.UNABLE_TO_FIND_CHUNK;
        }
        if (cause instanceof IOException) {
            return ContainerProtos.Result.IO_EXCEPTION;
        }
        if (cause instanceof NoSuchAlgorithmException) {
            return ContainerProtos.Result.NO_SUCH_ALGORITHM;
        }
        return ContainerProtos.Result.CONTAINER_INTERNAL_ERROR;
    }
}

