/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.keyvalue;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdfs.util.Canceler;
import org.apache.hadoop.hdfs.util.DataTransferThrottler;
import org.apache.hadoop.ozone.common.Checksum;
import org.apache.hadoop.ozone.common.ChecksumData;
import org.apache.hadoop.ozone.common.OzoneChecksumException;
import org.apache.hadoop.ozone.container.common.helpers.BlockData;
import org.apache.hadoop.ozone.container.common.helpers.ChunkInfo;
import org.apache.hadoop.ozone.container.common.helpers.ContainerUtils;
import org.apache.hadoop.ozone.container.common.impl.ContainerDataYaml;
import org.apache.hadoop.ozone.container.common.interfaces.Container;
import org.apache.hadoop.ozone.container.common.utils.ReferenceCountedDB;
import org.apache.hadoop.ozone.container.keyvalue.KeyValueBlockIterator;
import org.apache.hadoop.ozone.container.keyvalue.KeyValueContainer;
import org.apache.hadoop.ozone.container.keyvalue.KeyValueContainerData;
import org.apache.hadoop.ozone.container.keyvalue.helpers.BlockUtils;
import org.apache.hadoop.ozone.container.keyvalue.helpers.ChunkUtils;
import org.apache.hadoop.ozone.container.keyvalue.helpers.KeyValueContainerLocationUtil;
import org.apache.hadoop.ozone.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.ozone.shaded.com.google.common.primitives.Longs;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyValueContainerCheck {
    private static final Logger LOG = LoggerFactory.getLogger(Container.class);
    private long containerID;
    private KeyValueContainerData onDiskContainerData;
    private Configuration checkConfig;
    private String metadataPath;

    public KeyValueContainerCheck(String metadataPath, Configuration conf, long containerID) {
        Preconditions.checkArgument(metadataPath != null);
        this.checkConfig = conf;
        this.containerID = containerID;
        this.onDiskContainerData = null;
        this.metadataPath = metadataPath;
    }

    public boolean fastCheck() {
        LOG.info("Running basic checks for container {};", (Object)this.containerID);
        boolean valid = false;
        try {
            this.loadContainerData();
            this.checkLayout();
            this.checkContainerFile();
            valid = true;
        }
        catch (IOException e) {
            this.handleCorruption(e);
        }
        return valid;
    }

    public boolean fullCheck(DataTransferThrottler throttler, Canceler canceler) {
        boolean valid;
        try {
            valid = this.fastCheck();
            if (valid) {
                this.scanData(throttler, canceler);
            }
        }
        catch (IOException e) {
            this.handleCorruption(e);
            valid = false;
        }
        return valid;
    }

    private void checkLayout() throws IOException {
        this.checkDirPath(this.metadataPath);
        String chunksPath = this.onDiskContainerData.getChunksPath();
        this.checkDirPath(chunksPath);
    }

    private void checkDirPath(String path) throws IOException {
        File dirPath = new File(path);
        try {
            if (!dirPath.isDirectory()) {
                String errStr = "Not a directory [" + path + "]";
                throw new IOException(errStr);
            }
        }
        catch (SecurityException se) {
            throw new IOException("Security exception checking dir [" + path + "]", se);
        }
        String[] ls = dirPath.list();
        if (ls == null) {
            String errStr = "null listing for directory [" + path + "]";
            throw new IOException(errStr);
        }
    }

    private void checkContainerFile() throws IOException {
        Preconditions.checkState(this.onDiskContainerData != null, "Container File not loaded");
        ContainerUtils.verifyChecksum(this.onDiskContainerData);
        if (this.onDiskContainerData.getContainerType() != ContainerProtos.ContainerType.KeyValueContainer) {
            String errStr = "Bad Container type in Containerdata for " + this.containerID;
            throw new IOException(errStr);
        }
        if (this.onDiskContainerData.getContainerID() != this.containerID) {
            String errStr = "Bad ContainerID field in Containerdata for " + this.containerID;
            throw new IOException(errStr);
        }
        String dbType = this.onDiskContainerData.getContainerDBType();
        if (!dbType.equals("RocksDB") && !dbType.equals("LevelDB")) {
            String errStr = "Unknown DBType [" + dbType + "] in Container File for  [" + this.containerID + "]";
            throw new IOException(errStr);
        }
        KeyValueContainerData kvData = this.onDiskContainerData;
        if (!this.metadataPath.equals(kvData.getMetadataPath())) {
            String errStr = "Bad metadata path in Containerdata for " + this.containerID + "Expected [" + this.metadataPath + "] Got [" + kvData.getMetadataPath() + "]";
            throw new IOException(errStr);
        }
    }

    private void scanData(DataTransferThrottler throttler, Canceler canceler) throws IOException {
        Preconditions.checkState(this.onDiskContainerData != null, "invoke loadContainerData prior to calling this function");
        File metaDir = new File(this.metadataPath);
        File dbFile = KeyValueContainerLocationUtil.getContainerDBFile(metaDir, this.containerID);
        if (!dbFile.exists() || !dbFile.canRead()) {
            String dbFileErrorMsg = "Unable to access DB File [" + dbFile.toString() + "] for Container [" + this.containerID + "] metadata path [" + this.metadataPath + "]";
            throw new IOException(dbFileErrorMsg);
        }
        this.onDiskContainerData.setDbFile(dbFile);
        try (ReferenceCountedDB db = BlockUtils.getDB(this.onDiskContainerData, this.checkConfig);
             KeyValueBlockIterator kvIter = new KeyValueBlockIterator(this.containerID, new File(this.onDiskContainerData.getContainerPath()));){
            while (kvIter.hasNext()) {
                BlockData block = kvIter.nextBlock();
                for (ContainerProtos.ChunkInfo chunk : block.getChunks()) {
                    File chunkFile = ChunkUtils.getChunkFile(this.onDiskContainerData, ChunkInfo.getFromProtoBuf(chunk));
                    if (!chunkFile.exists()) {
                        byte[] bdata = db.getStore().get(Longs.toByteArray(block.getBlockID().getLocalID()));
                        if (bdata == null) continue;
                        throw new IOException("Missing chunk file " + chunkFile.getAbsolutePath());
                    }
                    if (chunk.getChecksumData().getType() == ContainerProtos.ChecksumType.NONE) continue;
                    int length = chunk.getChecksumData().getChecksumsList().size();
                    ChecksumData cData = new ChecksumData(chunk.getChecksumData().getType(), chunk.getChecksumData().getBytesPerChecksum(), chunk.getChecksumData().getChecksumsList());
                    Checksum cal = new Checksum(cData.getChecksumType(), cData.getBytesPerChecksum());
                    long bytesRead = 0L;
                    byte[] buffer = new byte[cData.getBytesPerChecksum()];
                    FileInputStream fs = new FileInputStream(chunkFile);
                    Throwable throwable = null;
                    try {
                        int v;
                        for (int i = 0; i < length && (v = ((InputStream)fs).read(buffer)) != -1; ++i) {
                            bytesRead += (long)v;
                            throttler.throttle((long)v, canceler);
                            ByteString expected = cData.getChecksums().get(i);
                            ByteString actual = cal.computeChecksum(buffer, 0, v).getChecksums().get(0);
                            if (expected.equals(actual)) continue;
                            throw new OzoneChecksumException(String.format("Inconsistent read for chunk=%s len=%d expected checksum %s actual checksum %s for block %s", chunk.getChunkName(), chunk.getLen(), Arrays.toString(expected.toByteArray()), Arrays.toString(actual.toByteArray()), block.getBlockID()));
                        }
                        if (bytesRead == chunk.getLen()) continue;
                        throw new OzoneChecksumException(String.format("Inconsistent read for chunk=%s expected length=%d actual length=%d for block %s", chunk.getChunkName(), chunk.getLen(), bytesRead, block.getBlockID()));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (fs == null) continue;
                        if (throwable != null) {
                            try {
                                ((InputStream)fs).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        ((InputStream)fs).close();
                    }
                }
            }
        }
    }

    private void loadContainerData() throws IOException {
        File containerFile = KeyValueContainer.getContainerFile(this.metadataPath, this.containerID);
        this.onDiskContainerData = (KeyValueContainerData)ContainerDataYaml.readContainerFile(containerFile);
    }

    private void handleCorruption(IOException e) {
        String errStr = "Corruption detected in container: [" + this.containerID + "] ";
        String logMessage = errStr + "Exception: [" + e.getMessage() + "]";
        LOG.error(logMessage);
    }
}

