/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.keyvalue;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.NoSuchElementException;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.utils.MetaStoreIterator;
import org.apache.hadoop.hdds.utils.MetadataKeyFilters;
import org.apache.hadoop.hdds.utils.MetadataStore;
import org.apache.hadoop.ozone.container.common.helpers.BlockData;
import org.apache.hadoop.ozone.container.common.helpers.ContainerUtils;
import org.apache.hadoop.ozone.container.common.impl.ContainerData;
import org.apache.hadoop.ozone.container.common.impl.ContainerDataYaml;
import org.apache.hadoop.ozone.container.common.interfaces.BlockIterator;
import org.apache.hadoop.ozone.container.common.utils.ReferenceCountedDB;
import org.apache.hadoop.ozone.container.keyvalue.KeyValueContainerData;
import org.apache.hadoop.ozone.container.keyvalue.helpers.BlockUtils;
import org.apache.hadoop.ozone.container.keyvalue.helpers.KeyValueContainerLocationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
public class KeyValueBlockIterator
implements BlockIterator<BlockData>,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(KeyValueBlockIterator.class);
    private MetaStoreIterator<MetadataStore.KeyValue> blockIterator;
    private final ReferenceCountedDB db;
    private static MetadataKeyFilters.KeyPrefixFilter defaultBlockFilter = MetadataKeyFilters.getNormalKeyFilter();
    private MetadataKeyFilters.KeyPrefixFilter blockFilter;
    private BlockData nextBlock;
    private long containerId;

    public KeyValueBlockIterator(long id, File path) throws IOException {
        this(id, path, defaultBlockFilter);
    }

    public KeyValueBlockIterator(long id, File path, MetadataKeyFilters.KeyPrefixFilter filter) throws IOException {
        this.containerId = id;
        File metdataPath = new File(path, "metadata");
        File containerFile = ContainerUtils.getContainerFile(metdataPath.getParentFile());
        ContainerData containerData = ContainerDataYaml.readContainerFile(containerFile);
        KeyValueContainerData keyValueContainerData = (KeyValueContainerData)containerData;
        keyValueContainerData.setDbFile(KeyValueContainerLocationUtil.getContainerDBFile(metdataPath, this.containerId));
        this.db = BlockUtils.getDB(keyValueContainerData, new OzoneConfiguration());
        this.blockIterator = this.db.getStore().iterator();
        this.blockFilter = filter;
    }

    @Override
    public BlockData nextBlock() throws IOException, NoSuchElementException {
        if (this.nextBlock != null) {
            BlockData currentBlock = this.nextBlock;
            this.nextBlock = null;
            return currentBlock;
        }
        if (this.hasNext()) {
            return this.nextBlock();
        }
        throw new NoSuchElementException("Block Iterator reached end for ContainerID " + this.containerId);
    }

    @Override
    public boolean hasNext() throws IOException {
        if (this.nextBlock != null) {
            return true;
        }
        if (this.blockIterator.hasNext()) {
            MetadataStore.KeyValue block = (MetadataStore.KeyValue)this.blockIterator.next();
            if (this.blockFilter.filterKey(null, block.getKey(), null)) {
                this.nextBlock = BlockUtils.getBlockData(block.getValue());
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Block matching with filter found: blockID is : {} for containerID {}", (Object)this.nextBlock.getLocalID(), (Object)this.containerId);
                }
                return true;
            }
            this.hasNext();
        }
        return false;
    }

    @Override
    public void seekToFirst() {
        this.nextBlock = null;
        this.blockIterator.seekToFirst();
    }

    @Override
    public void seekToLast() {
        this.nextBlock = null;
        this.blockIterator.seekToLast();
    }

    @Override
    public void close() {
        this.db.close();
    }
}

