/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.volume;

import org.apache.hadoop.hdds.fs.CachingSpaceUsageSource;
import org.apache.hadoop.hdds.fs.SpaceUsageCheckParams;
import org.apache.hadoop.hdds.fs.SpaceUsageSource;

public class VolumeUsage
implements SpaceUsageSource {
    private final CachingSpaceUsageSource source;
    private boolean shutdownComplete;

    VolumeUsage(SpaceUsageCheckParams checkParams) {
        this.source = new CachingSpaceUsageSource(checkParams);
        this.start();
    }

    @Override
    public long getCapacity() {
        return Math.max(this.source.getCapacity(), 0L);
    }

    @Override
    public long getAvailable() {
        long l = this.source.getCapacity() - this.source.getUsedSpace();
        return Math.max(Math.min(l, this.source.getAvailable()), 0L);
    }

    @Override
    public long getUsedSpace() {
        return this.source.getUsedSpace();
    }

    public synchronized void start() {
        this.source.start();
    }

    public synchronized void shutdown() {
        if (!this.shutdownComplete) {
            this.source.shutdown();
            this.shutdownComplete = true;
        }
    }
}

