/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.volume;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdds.fs.SpaceUsageCheckFactory;
import org.apache.hadoop.hdds.fs.SpaceUsageCheckParams;
import org.apache.hadoop.ozone.container.common.volume.VolumeUsage;
import org.apache.hadoop.ozone.shaded.com.google.common.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VolumeInfo {
    private static final Logger LOG = LoggerFactory.getLogger(VolumeInfo.class);
    private final String rootDir;
    private final StorageType storageType;
    private final VolumeUsage usage;
    private long configuredCapacity;

    private VolumeInfo(Builder b) throws IOException {
        boolean succeeded;
        this.rootDir = b.rootDir;
        File root = new File(this.rootDir);
        boolean bl = succeeded = root.isDirectory() || root.mkdirs();
        if (!succeeded) {
            LOG.error("Unable to create the volume root dir at : {}", (Object)root);
            throw new IOException("Unable to create the volume root dir at " + root);
        }
        this.storageType = b.storageType != null ? b.storageType : StorageType.DEFAULT;
        this.configuredCapacity = b.configuredCapacity != 0L ? b.configuredCapacity : -1L;
        SpaceUsageCheckFactory usageCheckFactory = b.usageCheckFactory;
        if (usageCheckFactory == null) {
            usageCheckFactory = SpaceUsageCheckFactory.create(b.conf);
        }
        SpaceUsageCheckParams checkParams = usageCheckFactory.paramsFor(root);
        this.usage = new VolumeUsage(checkParams);
    }

    public long getCapacity() {
        if (this.configuredCapacity < 0L) {
            return this.usage.getCapacity();
        }
        return this.configuredCapacity;
    }

    public long getAvailable() {
        return this.usage.getAvailable();
    }

    public long getScmUsed() {
        return this.usage.getUsedSpace();
    }

    void start() {
        this.usage.start();
    }

    void shutdownUsageThread() {
        this.usage.shutdown();
    }

    public String getRootDir() {
        return this.rootDir;
    }

    public StorageType getStorageType() {
        return this.storageType;
    }

    @VisibleForTesting
    public VolumeUsage getUsageForTesting() {
        return this.usage;
    }

    public static class Builder {
        private final Configuration conf;
        private final String rootDir;
        private SpaceUsageCheckFactory usageCheckFactory;
        private StorageType storageType;
        private long configuredCapacity;

        public Builder(String root, Configuration config) {
            this.rootDir = root;
            this.conf = config;
        }

        public Builder storageType(StorageType st) {
            this.storageType = st;
            return this;
        }

        public Builder configuredCapacity(long capacity) {
            this.configuredCapacity = capacity;
            return this;
        }

        public Builder usageCheckFactory(SpaceUsageCheckFactory factory) {
            this.usageCheckFactory = factory;
            return this;
        }

        public VolumeInfo build() throws IOException {
            return new VolumeInfo(this);
        }
    }
}

