/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.volume;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.annotation.InterfaceStability;
import org.apache.hadoop.hdfs.server.datanode.checker.Checkable;
import org.apache.hadoop.ozone.container.common.volume.AsyncChecker;
import org.apache.hadoop.ozone.container.common.volume.TimeoutFuture;
import org.apache.hadoop.ozone.shaded.com.google.common.util.concurrent.FutureCallback;
import org.apache.hadoop.ozone.shaded.com.google.common.util.concurrent.Futures;
import org.apache.hadoop.ozone.shaded.com.google.common.util.concurrent.ListenableFuture;
import org.apache.hadoop.ozone.shaded.com.google.common.util.concurrent.ListeningExecutorService;
import org.apache.hadoop.ozone.shaded.com.google.common.util.concurrent.MoreExecutors;
import org.apache.hadoop.util.Timer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ThrottledAsyncChecker<K, V>
implements AsyncChecker<K, V> {
    public static final Logger LOG = LoggerFactory.getLogger(ThrottledAsyncChecker.class);
    private final Timer timer;
    private final ListeningExecutorService executorService;
    private final ScheduledExecutorService scheduledExecutorService;
    private final long minMsBetweenChecks;
    private final long diskCheckTimeout;
    private final Map<Checkable, ListenableFuture<V>> checksInProgress;
    private final Map<Checkable, LastCheckResult<V>> completedChecks;

    public ThrottledAsyncChecker(Timer timer, long minMsBetweenChecks, long diskCheckTimeout, ExecutorService executorService) {
        this.timer = timer;
        this.minMsBetweenChecks = minMsBetweenChecks;
        this.diskCheckTimeout = diskCheckTimeout;
        this.executorService = MoreExecutors.listeningDecorator(executorService);
        this.checksInProgress = new HashMap<Checkable, ListenableFuture<V>>();
        this.completedChecks = new WeakHashMap<Checkable, LastCheckResult<V>>();
        if (this.diskCheckTimeout > 0L) {
            ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(1);
            this.scheduledExecutorService = MoreExecutors.getExitingScheduledExecutorService(scheduledThreadPoolExecutor);
        } else {
            this.scheduledExecutorService = null;
        }
    }

    @Override
    public Optional<ListenableFuture<V>> schedule(Checkable<K, V> target, K context) {
        if (this.checksInProgress.containsKey(target)) {
            return Optional.empty();
        }
        if (this.completedChecks.containsKey(target)) {
            LastCheckResult<V> result = this.completedChecks.get(target);
            long msSinceLastCheck = this.timer.monotonicNow() - ((LastCheckResult)result).completedAt;
            if (msSinceLastCheck < this.minMsBetweenChecks) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Skipped checking {}. Time since last check {}ms is less than the min gap {}ms.", new Object[]{target, msSinceLastCheck, this.minMsBetweenChecks});
                }
                return Optional.empty();
            }
        }
        LOG.info("Scheduling a check for {}", target);
        ListenableFuture lfWithoutTimeout = this.executorService.submit(() -> target.check(context));
        ListenableFuture lf = this.diskCheckTimeout > 0L ? TimeoutFuture.create(lfWithoutTimeout, this.diskCheckTimeout, TimeUnit.MILLISECONDS, this.scheduledExecutorService) : lfWithoutTimeout;
        this.checksInProgress.put(target, lf);
        this.addResultCachingCallback(target, lf);
        return Optional.of(lf);
    }

    private void addResultCachingCallback(final Checkable<K, V> target, ListenableFuture<V> lf) {
        Futures.addCallback(lf, new FutureCallback<V>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSuccess(@Nullable V result) {
                ThrottledAsyncChecker throttledAsyncChecker = ThrottledAsyncChecker.this;
                synchronized (throttledAsyncChecker) {
                    ThrottledAsyncChecker.this.checksInProgress.remove(target);
                    ThrottledAsyncChecker.this.completedChecks.put(target, new LastCheckResult(result, ThrottledAsyncChecker.this.timer.monotonicNow()));
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFailure(@Nonnull Throwable t) {
                ThrottledAsyncChecker throttledAsyncChecker = ThrottledAsyncChecker.this;
                synchronized (throttledAsyncChecker) {
                    ThrottledAsyncChecker.this.checksInProgress.remove(target);
                    ThrottledAsyncChecker.this.completedChecks.put(target, new LastCheckResult(t, ThrottledAsyncChecker.this.timer.monotonicNow()));
                }
            }
        }, MoreExecutors.directExecutor());
    }

    @Override
    public void shutdownAndWait(long timeout, TimeUnit timeUnit) throws InterruptedException {
        if (this.scheduledExecutorService != null) {
            this.scheduledExecutorService.shutdownNow();
            this.scheduledExecutorService.awaitTermination(timeout, timeUnit);
        }
        this.executorService.shutdownNow();
        this.executorService.awaitTermination(timeout, timeUnit);
    }

    private static final class LastCheckResult<V> {
        private final long completedAt;
        private final @Nullable V result;
        private final Throwable exception;

        private LastCheckResult(V result, long completedAt) {
            this.result = result;
            this.exception = null;
            this.completedAt = completedAt;
        }

        private LastCheckResult(Throwable t, long completedAt) {
            this.result = null;
            this.exception = t;
            this.completedAt = completedAt;
        }
    }
}

