/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.transport.server.ratis;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.StorageUnit;
import org.apache.hadoop.hdds.conf.DatanodeRatisServerConfig;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.ratis.ContainerCommandRequestMessage;
import org.apache.hadoop.hdds.ratis.RatisHelper;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.security.x509.SecurityConfig;
import org.apache.hadoop.hdds.security.x509.certificate.client.CertificateClient;
import org.apache.hadoop.hdds.tracing.TracingUtil;
import org.apache.hadoop.hdds.utils.HddsServerUtil;
import org.apache.hadoop.ozone.OzoneConfigKeys;
import org.apache.hadoop.ozone.container.common.impl.ContainerData;
import org.apache.hadoop.ozone.container.common.interfaces.Container;
import org.apache.hadoop.ozone.container.common.interfaces.ContainerDispatcher;
import org.apache.hadoop.ozone.container.common.statemachine.StateContext;
import org.apache.hadoop.ozone.container.common.transport.server.XceiverServerSpi;
import org.apache.hadoop.ozone.container.common.transport.server.ratis.ContainerStateMachine;
import org.apache.hadoop.ozone.container.common.transport.server.ratis.RatisServerConfiguration;
import org.apache.hadoop.ozone.container.ozoneimpl.ContainerController;
import org.apache.hadoop.ozone.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.ozone.shaded.com.google.common.collect.ImmutableList;
import org.apache.hadoop.ozone.shaded.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.hadoop.ozone.shaded.io.opentracing.Scope;
import org.apache.ratis.RaftConfigKeys;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.grpc.GrpcConfigKeys;
import org.apache.ratis.grpc.GrpcFactory;
import org.apache.ratis.grpc.GrpcTlsConfig;
import org.apache.ratis.netty.NettyConfigKeys;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.GroupInfoReply;
import org.apache.ratis.protocol.GroupInfoRequest;
import org.apache.ratis.protocol.GroupManagementRequest;
import org.apache.ratis.protocol.NotLeaderException;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftGroupMemberId;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.StateMachineException;
import org.apache.ratis.rpc.RpcType;
import org.apache.ratis.rpc.SupportedRpcType;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.impl.RaftServerProxy;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.util.SizeInBytes;
import org.apache.ratis.util.TimeDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class XceiverServerRatis
implements XceiverServerSpi {
    private static final Logger LOG = LoggerFactory.getLogger(XceiverServerRatis.class);
    private static final AtomicLong CALL_ID_COUNTER = new AtomicLong();
    private int port;
    private final RaftServer server;
    private final List<ThreadPoolExecutor> chunkExecutors;
    private final ContainerDispatcher dispatcher;
    private final ContainerController containerController;
    private ClientId clientId = ClientId.randomId();
    private final StateContext context;
    private long nodeFailureTimeoutMs;
    private boolean isStarted = false;
    private DatanodeDetails datanodeDetails;
    private final OzoneConfiguration conf;
    private final Set<RaftGroupId> raftGids = new HashSet<RaftGroupId>();
    private final RaftPeerId raftPeerId;
    private Map<RaftGroupId, Boolean> groupLeaderMap = new ConcurrentHashMap<RaftGroupId, Boolean>();

    private static long nextCallId() {
        return CALL_ID_COUNTER.getAndIncrement() & Long.MAX_VALUE;
    }

    private XceiverServerRatis(DatanodeDetails dd, int port, ContainerDispatcher dispatcher, ContainerController containerController, StateContext context, GrpcTlsConfig tlsConfig, OzoneConfiguration conf) throws IOException {
        this.conf = conf;
        Objects.requireNonNull(dd, "id == null");
        this.datanodeDetails = dd;
        this.port = port;
        RaftProperties serverProperties = this.newRaftProperties();
        this.context = context;
        this.dispatcher = dispatcher;
        this.containerController = containerController;
        this.raftPeerId = RatisHelper.toRaftPeerId(dd);
        this.chunkExecutors = XceiverServerRatis.createChunkExecutors(conf);
        RaftServer.Builder builder = RaftServer.newBuilder().setServerId(this.raftPeerId).setProperties(serverProperties).setStateMachineRegistry(this::getStateMachine);
        if (tlsConfig != null) {
            builder.setParameters(GrpcFactory.newRaftParameters(tlsConfig));
        }
        this.server = builder.build();
    }

    private ContainerStateMachine getStateMachine(RaftGroupId gid) {
        return new ContainerStateMachine(gid, this.dispatcher, this.containerController, this.chunkExecutors, this, this.conf);
    }

    private RaftProperties newRaftProperties() {
        RaftProperties properties = new RaftProperties();
        RpcType rpc = this.setRpcType(properties);
        this.setRaftSegmentAndWriteBufferSize(properties);
        int raftSegmentPreallocatedSize = this.setRaftSegmentPreallocatedSize(properties);
        RaftServerConfigKeys.Log.StateMachineData.setSync(properties, true);
        TimeUnit timeUnit = OzoneConfigKeys.DFS_CONTAINER_RATIS_STATEMACHINEDATA_SYNC_TIMEOUT_DEFAULT.getUnit();
        long duration = this.conf.getTimeDuration("dfs.container.ratis.statemachinedata.sync.timeout", OzoneConfigKeys.DFS_CONTAINER_RATIS_STATEMACHINEDATA_SYNC_TIMEOUT_DEFAULT.getDuration(), timeUnit);
        TimeDuration dataSyncTimeout = TimeDuration.valueOf(duration, timeUnit);
        RaftServerConfigKeys.Log.StateMachineData.setSyncTimeout(properties, dataSyncTimeout);
        this.setTimeoutForRetryCache(properties);
        this.setRatisLeaderElectionTimeout(properties);
        RaftServerConfigKeys.Log.setMaxCachedSegmentNum(properties, 2);
        this.setNodeFailureTimeout(properties);
        String storageDir = HddsServerUtil.getOzoneDatanodeRatisDirectory(this.conf);
        RaftServerConfigKeys.setStorageDirs(properties, Collections.singletonList(new File(storageDir)));
        GrpcConfigKeys.setMessageSizeMax(properties, SizeInBytes.valueOf(0x2000000 + raftSegmentPreallocatedSize));
        if (rpc == SupportedRpcType.GRPC) {
            GrpcConfigKeys.Server.setPort(properties, this.port);
        } else if (rpc == SupportedRpcType.NETTY) {
            NettyConfigKeys.Server.setPort(properties, this.port);
        }
        long snapshotThreshold = this.conf.getLong("dfs.ratis.snapshot.threshold", 100000L);
        RaftServerConfigKeys.Snapshot.setAutoTriggerEnabled(properties, true);
        RaftServerConfigKeys.Snapshot.setAutoTriggerThreshold(properties, snapshotThreshold);
        this.setPendingRequestsLimits(properties);
        int logQueueNumElements = this.conf.getInt("dfs.container.ratis.log.queue.num-elements", 1024);
        int logQueueByteLimit = (int)this.conf.getStorageSize("dfs.container.ratis.log.queue.byte-limit", "4GB", StorageUnit.BYTES);
        RaftServerConfigKeys.Log.setQueueElementLimit(properties, logQueueNumElements);
        RaftServerConfigKeys.Log.setQueueByteLimit(properties, logQueueByteLimit);
        int numSyncRetries = this.conf.getInt("dfs.container.ratis.statemachinedata.sync.retries", -1);
        RaftServerConfigKeys.Log.StateMachineData.setSyncTimeoutRetry(properties, numSyncRetries);
        RaftServerConfigKeys.Log.StateMachineData.setCachingEnabled(properties, true);
        RaftServerConfigKeys.Log.Appender.setInstallSnapshotEnabled(properties, false);
        int purgeGap = this.conf.getInt("dfs.container.ratis.log.purge.gap", 1000000);
        RaftServerConfigKeys.Log.setPurgeGap(properties, purgeGap);
        RatisServerConfiguration ratisServerConfiguration = this.conf.getObject(RatisServerConfiguration.class);
        int numSnapshotsRetained = ratisServerConfiguration.getNumSnapshotsRetained();
        RaftServerConfigKeys.Snapshot.setRetentionFileNum(properties, numSnapshotsRetained);
        RatisHelper.createRaftServerProperties(this.conf, properties);
        return properties;
    }

    private void setNodeFailureTimeout(RaftProperties properties) {
        this.nodeFailureTimeoutMs = this.conf.getObject(DatanodeRatisServerConfig.class).getFollowerSlownessTimeout();
    }

    private void setRatisLeaderElectionTimeout(RaftProperties properties) {
        TimeUnit leaderElectionMinTimeoutUnit = OzoneConfigKeys.DFS_RATIS_LEADER_ELECTION_MINIMUM_TIMEOUT_DURATION_DEFAULT.getUnit();
        long duration = this.conf.getTimeDuration("dfs.ratis.leader.election.minimum.timeout.duration", OzoneConfigKeys.DFS_RATIS_LEADER_ELECTION_MINIMUM_TIMEOUT_DURATION_DEFAULT.getDuration(), leaderElectionMinTimeoutUnit);
        TimeDuration leaderElectionMinTimeout = TimeDuration.valueOf(duration, leaderElectionMinTimeoutUnit);
        RaftServerConfigKeys.Rpc.setTimeoutMin(properties, leaderElectionMinTimeout);
        long leaderElectionMaxTimeout = leaderElectionMinTimeout.toLong(TimeUnit.MILLISECONDS) + 200L;
        RaftServerConfigKeys.Rpc.setTimeoutMax(properties, TimeDuration.valueOf(leaderElectionMaxTimeout, TimeUnit.MILLISECONDS));
    }

    private void setTimeoutForRetryCache(RaftProperties properties) {
        TimeUnit timeUnit = OzoneConfigKeys.DFS_RATIS_SERVER_RETRY_CACHE_TIMEOUT_DURATION_DEFAULT.getUnit();
        long duration = this.conf.getTimeDuration("dfs.ratis.server.retry-cache.timeout.duration", OzoneConfigKeys.DFS_RATIS_SERVER_RETRY_CACHE_TIMEOUT_DURATION_DEFAULT.getDuration(), timeUnit);
        TimeDuration retryCacheTimeout = TimeDuration.valueOf(duration, timeUnit);
        RaftServerConfigKeys.RetryCache.setExpiryTime(properties, retryCacheTimeout);
    }

    private int setRaftSegmentPreallocatedSize(RaftProperties properties) {
        int raftSegmentPreallocatedSize = (int)this.conf.getStorageSize("dfs.container.ratis.segment.preallocated.size", "16KB", StorageUnit.BYTES);
        int logAppenderQueueNumElements = this.conf.getInt("dfs.container.ratis.log.appender.queue.num-elements", 1);
        int logAppenderQueueByteLimit = (int)this.conf.getStorageSize("dfs.container.ratis.log.appender.queue.byte-limit", "32MB", StorageUnit.BYTES);
        RaftServerConfigKeys.Log.Appender.setBufferElementLimit(properties, logAppenderQueueNumElements);
        RaftServerConfigKeys.Log.Appender.setBufferByteLimit(properties, SizeInBytes.valueOf(logAppenderQueueByteLimit));
        RaftServerConfigKeys.Log.setPreallocatedSize(properties, SizeInBytes.valueOf(raftSegmentPreallocatedSize));
        return raftSegmentPreallocatedSize;
    }

    private void setRaftSegmentAndWriteBufferSize(RaftProperties properties) {
        int raftSegmentSize = (int)this.conf.getStorageSize("dfs.container.ratis.segment.size", "1MB", StorageUnit.BYTES);
        RaftServerConfigKeys.Log.setSegmentSizeMax(properties, SizeInBytes.valueOf(raftSegmentSize));
        RaftServerConfigKeys.Log.setWriteBufferSize(properties, SizeInBytes.valueOf(raftSegmentSize));
    }

    private RpcType setRpcType(RaftProperties properties) {
        String rpcType = this.conf.get("dfs.container.ratis.rpc.type", "GRPC");
        SupportedRpcType rpc = SupportedRpcType.valueOfIgnoreCase(rpcType);
        RaftConfigKeys.Rpc.setType(properties, rpc);
        return rpc;
    }

    private void setPendingRequestsLimits(RaftProperties properties) {
        int pendingRequestsByteLimit = (int)this.conf.getStorageSize("dfs.container.ratis.leader.pending.bytes.limit", "1GB", StorageUnit.BYTES);
        RaftServerConfigKeys.Write.setByteLimit(properties, pendingRequestsByteLimit);
    }

    public static XceiverServerRatis newXceiverServerRatis(DatanodeDetails datanodeDetails, OzoneConfiguration ozoneConf, ContainerDispatcher dispatcher, ContainerController containerController, CertificateClient caClient, StateContext context) throws IOException {
        int localPort = ozoneConf.getInt("dfs.container.ratis.ipc", 9858);
        if (ozoneConf.getBoolean("dfs.container.ratis.ipc.random.port", false)) {
            localPort = 0;
        }
        GrpcTlsConfig tlsConfig = XceiverServerRatis.createTlsServerConfigForDN(new SecurityConfig(ozoneConf), caClient);
        return new XceiverServerRatis(datanodeDetails, localPort, dispatcher, containerController, context, tlsConfig, ozoneConf);
    }

    static GrpcTlsConfig createTlsServerConfigForDN(SecurityConfig conf, CertificateClient caClient) {
        if (conf.isSecurityEnabled() && conf.isGrpcTlsEnabled()) {
            return new GrpcTlsConfig(caClient.getPrivateKey(), caClient.getCertificate(), null, false);
        }
        return null;
    }

    @Override
    public void start() throws IOException {
        if (!this.isStarted) {
            LOG.info("Starting {} {} at port {}", new Object[]{this.getClass().getSimpleName(), this.server.getId(), this.getIPCPort()});
            for (ThreadPoolExecutor executor : this.chunkExecutors) {
                executor.prestartAllCoreThreads();
            }
            this.server.start();
            int realPort = ((RaftServerProxy)this.server).getServerRpc().getInetSocketAddress().getPort();
            if (this.port == 0) {
                LOG.info("{} {} is started using port {}", new Object[]{this.getClass().getSimpleName(), this.server.getId(), realPort});
                this.port = realPort;
            }
            this.datanodeDetails.setPort(DatanodeDetails.newPort(DatanodeDetails.Port.Name.RATIS, realPort));
            this.isStarted = true;
        }
    }

    @Override
    public void stop() {
        if (this.isStarted) {
            try {
                this.server.close();
                for (ExecutorService executorService : this.chunkExecutors) {
                    executorService.shutdown();
                }
                this.isStarted = false;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public int getIPCPort() {
        return this.port;
    }

    @Override
    public HddsProtos.ReplicationType getServerType() {
        return HddsProtos.ReplicationType.RATIS;
    }

    @VisibleForTesting
    public RaftServer getServer() {
        return this.server;
    }

    private void processReply(RaftClientReply reply) throws IOException {
        NotLeaderException notLeaderException = reply.getNotLeaderException();
        if (notLeaderException != null) {
            throw notLeaderException;
        }
        StateMachineException stateMachineException = reply.getStateMachineException();
        if (stateMachineException != null) {
            throw stateMachineException;
        }
    }

    @Override
    public void submitRequest(ContainerProtos.ContainerCommandRequestProto request, HddsProtos.PipelineID pipelineID) throws IOException {
        try (Scope scope = TracingUtil.importAndCreateScope("XceiverServerRatis." + request.getCmdType().name(), request.getTraceID());){
            RaftClientReply reply;
            RaftClientRequest raftClientRequest = this.createRaftClientRequest(request, pipelineID, RaftClientRequest.writeRequestType());
            try {
                reply = this.server.submitClientRequestAsync(raftClientRequest).get();
            }
            catch (Exception e) {
                throw new IOException(e.getMessage(), e);
            }
            this.processReply(reply);
        }
    }

    private RaftClientRequest createRaftClientRequest(ContainerProtos.ContainerCommandRequestProto request, HddsProtos.PipelineID pipelineID, RaftClientRequest.Type type) {
        return new RaftClientRequest(this.clientId, this.server.getId(), RaftGroupId.valueOf(PipelineID.getFromProtobuf(pipelineID).getId()), XceiverServerRatis.nextCallId(), ContainerCommandRequestMessage.toMessage(request, null), type, null);
    }

    private GroupInfoRequest createGroupInfoRequest(HddsProtos.PipelineID pipelineID) {
        return new GroupInfoRequest(this.clientId, this.server.getId(), RaftGroupId.valueOf(PipelineID.getFromProtobuf(pipelineID).getId()), XceiverServerRatis.nextCallId());
    }

    private void handlePipelineFailure(RaftGroupId groupId, RaftProtos.RoleInfoProto roleInfoProto) {
        String msg;
        UUID datanode = RatisHelper.toDatanodeId(roleInfoProto.getSelf());
        RaftPeerId id = RaftPeerId.valueOf(roleInfoProto.getSelf().getId());
        switch (roleInfoProto.getRole()) {
            case CANDIDATE: {
                msg = datanode + " is in candidate state for " + roleInfoProto.getCandidateInfo().getLastLeaderElapsedTimeMs() + "ms";
                break;
            }
            case LEADER: {
                StringBuilder sb = new StringBuilder();
                sb.append(datanode).append(" has not seen follower/s");
                for (RaftProtos.ServerRpcProto follower : roleInfoProto.getLeaderInfo().getFollowerInfoList()) {
                    if (follower.getLastRpcElapsedTimeMs() <= this.nodeFailureTimeoutMs) continue;
                    sb.append(" ").append(RatisHelper.toDatanodeId(follower.getId())).append(" for ").append(follower.getLastRpcElapsedTimeMs()).append("ms");
                }
                msg = sb.toString();
                break;
            }
            default: {
                LOG.error("unknown state: {}", (Object)roleInfoProto.getRole());
                throw new IllegalStateException("node" + id + " is in illegal role " + roleInfoProto.getRole());
            }
        }
        this.triggerPipelineClose(groupId, msg, StorageContainerDatanodeProtocolProtos.ClosePipelineInfo.Reason.PIPELINE_FAILED, false);
    }

    private void triggerPipelineClose(RaftGroupId groupId, String detail, StorageContainerDatanodeProtocolProtos.ClosePipelineInfo.Reason reasonCode, boolean triggerHB) {
        PipelineID pipelineID = PipelineID.valueOf(groupId.getUuid());
        StorageContainerDatanodeProtocolProtos.ClosePipelineInfo.Builder closePipelineInfo = StorageContainerDatanodeProtocolProtos.ClosePipelineInfo.newBuilder().setPipelineID(pipelineID.getProtobuf()).setReason(reasonCode).setDetailedReason(detail);
        StorageContainerDatanodeProtocolProtos.PipelineAction action = StorageContainerDatanodeProtocolProtos.PipelineAction.newBuilder().setClosePipeline(closePipelineInfo).setAction(StorageContainerDatanodeProtocolProtos.PipelineAction.Action.CLOSE).build();
        this.context.addPipelineActionIfAbsent(action);
        if (triggerHB) {
            this.context.getParent().triggerHeartbeat();
        }
        LOG.error("pipeline Action {} on pipeline {}.Reason : {}", new Object[]{action.getAction(), pipelineID, action.getClosePipeline().getDetailedReason()});
    }

    @Override
    public boolean isExist(HddsProtos.PipelineID pipelineId) {
        return this.raftGids.contains(RaftGroupId.valueOf(PipelineID.getFromProtobuf(pipelineId).getId()));
    }

    private long calculatePipelineBytesWritten(HddsProtos.PipelineID pipelineID) {
        long bytesWritten = 0L;
        Iterator<Container<?>> containerIt = this.containerController.getContainers();
        while (containerIt.hasNext()) {
            Object containerData = containerIt.next().getContainerData();
            if (((ContainerData)containerData).getOriginPipelineId().compareTo(pipelineID.getId()) != 0) continue;
            bytesWritten += ((ContainerData)containerData).getWriteBytes();
        }
        return bytesWritten;
    }

    @Override
    public List<StorageContainerDatanodeProtocolProtos.PipelineReport> getPipelineReport() {
        try {
            Iterable<RaftGroupId> gids = this.server.getGroupIds();
            ArrayList<StorageContainerDatanodeProtocolProtos.PipelineReport> reports = new ArrayList<StorageContainerDatanodeProtocolProtos.PipelineReport>();
            for (RaftGroupId groupId : gids) {
                HddsProtos.PipelineID pipelineID = PipelineID.valueOf(groupId.getUuid()).getProtobuf();
                reports.add(StorageContainerDatanodeProtocolProtos.PipelineReport.newBuilder().setPipelineID(pipelineID).setIsLeader(this.groupLeaderMap.getOrDefault(groupId, Boolean.FALSE)).setBytesWritten(this.calculatePipelineBytesWritten(pipelineID)).build());
            }
            return reports;
        }
        catch (Exception e) {
            return null;
        }
    }

    @VisibleForTesting
    public List<PipelineID> getPipelineIds() {
        Iterable<RaftGroupId> gids = this.server.getGroupIds();
        ArrayList<PipelineID> pipelineIDs = new ArrayList<PipelineID>();
        for (RaftGroupId groupId : gids) {
            pipelineIDs.add(PipelineID.valueOf(groupId.getUuid()));
            LOG.info("pipeline id {}", (Object)PipelineID.valueOf(groupId.getUuid()));
        }
        return pipelineIDs;
    }

    @Override
    public void addGroup(HddsProtos.PipelineID pipelineId, Collection<DatanodeDetails> peers) throws IOException {
        RaftClientReply reply;
        PipelineID pipelineID = PipelineID.getFromProtobuf(pipelineId);
        RaftGroupId groupId = RaftGroupId.valueOf(pipelineID.getId());
        RaftGroup group = RatisHelper.newRaftGroup(groupId, peers);
        GroupManagementRequest request = GroupManagementRequest.newAdd(this.clientId, this.server.getId(), XceiverServerRatis.nextCallId(), group);
        try {
            reply = this.server.groupManagement(request);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
        this.processReply(reply);
    }

    @Override
    public void removeGroup(HddsProtos.PipelineID pipelineId) throws IOException {
        RaftClientReply reply;
        GroupManagementRequest request = GroupManagementRequest.newRemove(this.clientId, this.server.getId(), XceiverServerRatis.nextCallId(), RaftGroupId.valueOf(PipelineID.getFromProtobuf(pipelineId).getId()), true);
        try {
            reply = this.server.groupManagement(request);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
        this.processReply(reply);
    }

    void handleNodeSlowness(RaftGroupId groupId, RaftProtos.RoleInfoProto roleInfoProto) {
        this.handlePipelineFailure(groupId, roleInfoProto);
    }

    void handleNoLeader(RaftGroupId groupId, RaftProtos.RoleInfoProto roleInfoProto) {
        this.handlePipelineFailure(groupId, roleInfoProto);
    }

    void handleApplyTransactionFailure(RaftGroupId groupId, RaftProtos.RaftPeerRole role) {
        UUID dnId = RatisHelper.toDatanodeId(this.getServer().getId());
        String msg = "Ratis Transaction failure in datanode " + dnId + " with role " + role + " .Triggering pipeline close action.";
        this.triggerPipelineClose(groupId, msg, StorageContainerDatanodeProtocolProtos.ClosePipelineInfo.Reason.STATEMACHINE_TRANSACTION_FAILED, true);
    }

    void handleInstallSnapshotFromLeader(RaftGroupId groupId, RaftProtos.RoleInfoProto roleInfoProto, TermIndex firstTermIndexInLog) {
        LOG.warn("Install snapshot notification received from Leader with termIndex: {}, terminating pipeline: {}", (Object)firstTermIndexInLog, (Object)groupId);
        this.handlePipelineFailure(groupId, roleInfoProto);
    }

    @VisibleForTesting
    public void handleNodeLogFailure(RaftGroupId groupId, Throwable t) {
        String msg = t == null ? "Unspecified failure reported in Ratis log" : t.getMessage();
        this.triggerPipelineClose(groupId, msg, StorageContainerDatanodeProtocolProtos.ClosePipelineInfo.Reason.PIPELINE_LOG_FAILED, true);
    }

    public long getMinReplicatedIndex(PipelineID pipelineID) throws IOException {
        GroupInfoReply reply = this.getServer().getGroupInfo(this.createGroupInfoRequest(pipelineID.getProtobuf()));
        Long minIndex = RatisHelper.getMinReplicatedIndex(reply.getCommitInfos());
        return minIndex == null ? -1L : minIndex;
    }

    void notifyGroupRemove(RaftGroupId gid) {
        this.raftGids.remove(gid);
        this.groupLeaderMap.remove(gid);
    }

    void notifyGroupAdd(RaftGroupId gid) {
        this.raftGids.add(gid);
        this.sendPipelineReport();
    }

    void handleLeaderChangedNotification(RaftGroupMemberId groupMemberId, RaftPeerId raftPeerId1) {
        LOG.info("Leader change notification received for group: {} with new leaderId: {}", (Object)groupMemberId.getGroupId(), (Object)raftPeerId1);
        boolean leaderForGroup = this.raftPeerId.equals(raftPeerId1);
        this.groupLeaderMap.put(groupMemberId.getGroupId(), leaderForGroup);
        if (this.context != null && leaderForGroup) {
            this.sendPipelineReport();
        }
    }

    private void sendPipelineReport() {
        this.context.addReport(this.context.getParent().getContainer().getPipelineReport());
        this.context.getParent().triggerHeartbeat();
    }

    private static List<ThreadPoolExecutor> createChunkExecutors(Configuration conf) {
        int threadCount = conf.getInt("dfs.container.ratis.num.write.chunk.threads", 60);
        ThreadPoolExecutor[] executors = new ThreadPoolExecutor[threadCount];
        for (int i = 0; i < executors.length; ++i) {
            ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("ChunkWriter-" + i + "-%d").build();
            LinkedBlockingDeque<Runnable> workQueue = new LinkedBlockingDeque<Runnable>();
            executors[i] = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.SECONDS, workQueue, threadFactory);
        }
        return ImmutableList.copyOf(executors);
    }
}

