/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.transport.server.ratis;

import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableRate;
import org.apache.hadoop.ozone.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.ratis.protocol.RaftGroupId;

@InterfaceAudience.Private
@Metrics(about="Container State Machine Metrics", context="dfs")
public class CSMMetrics {
    public static final String SOURCE_NAME = CSMMetrics.class.getSimpleName();
    @Metric
    private MutableCounterLong numWriteStateMachineOps;
    @Metric
    private MutableCounterLong numQueryStateMachineOps;
    @Metric
    private MutableCounterLong numApplyTransactionOps;
    @Metric
    private MutableCounterLong numReadStateMachineOps;
    @Metric
    private MutableCounterLong numBytesWrittenCount;
    @Metric
    private MutableCounterLong numBytesCommittedCount;
    @Metric
    private MutableRate transactionLatency;
    private MutableRate[] opsLatency;
    private MetricsRegistry registry = null;
    @Metric
    private MutableCounterLong numWriteStateMachineFails;
    @Metric
    private MutableCounterLong numWriteDataFails;
    @Metric
    private MutableCounterLong numQueryStateMachineFails;
    @Metric
    private MutableCounterLong numApplyTransactionFails;
    @Metric
    private MutableCounterLong numReadStateMachineFails;
    @Metric
    private MutableCounterLong numReadStateMachineMissCount;
    @Metric
    private MutableCounterLong numStartTransactionVerifyFailures;
    @Metric
    private MutableCounterLong numContainerNotOpenVerifyFailures;
    @Metric
    private MutableRate applyTransaction;
    @Metric
    private MutableRate writeStateMachineData;

    public CSMMetrics() {
        int numCmdTypes = ContainerProtos.Type.values().length;
        this.opsLatency = new MutableRate[numCmdTypes];
        this.registry = new MetricsRegistry(CSMMetrics.class.getSimpleName());
        for (int i = 0; i < numCmdTypes; ++i) {
            this.opsLatency[i] = this.registry.newRate(ContainerProtos.Type.forNumber(i + 1).toString(), ContainerProtos.Type.forNumber(i + 1) + " op");
        }
    }

    public static CSMMetrics create(RaftGroupId gid) {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        return (CSMMetrics)ms.register(SOURCE_NAME + gid.toString(), "Container State Machine", (Object)new CSMMetrics());
    }

    public void incNumWriteStateMachineOps() {
        this.numWriteStateMachineOps.incr();
    }

    public void incNumQueryStateMachineOps() {
        this.numQueryStateMachineOps.incr();
    }

    public void incNumReadStateMachineOps() {
        this.numReadStateMachineOps.incr();
    }

    public void incNumApplyTransactionsOps() {
        this.numApplyTransactionOps.incr();
    }

    public void incNumWriteStateMachineFails() {
        this.numWriteStateMachineFails.incr();
    }

    public void incNumWriteDataFails() {
        this.numWriteDataFails.incr();
    }

    public void incNumQueryStateMachineFails() {
        this.numQueryStateMachineFails.incr();
    }

    public void incNumBytesWrittenCount(long value) {
        this.numBytesWrittenCount.incr(value);
    }

    public void incNumBytesCommittedCount(long value) {
        this.numBytesCommittedCount.incr(value);
    }

    public void incNumReadStateMachineFails() {
        this.numReadStateMachineFails.incr();
    }

    public void incNumReadStateMachineMissCount() {
        this.numReadStateMachineMissCount.incr();
    }

    public void incNumApplyTransactionsFails() {
        this.numApplyTransactionFails.incr();
    }

    @VisibleForTesting
    public long getNumWriteStateMachineOps() {
        return this.numWriteStateMachineOps.value();
    }

    @VisibleForTesting
    public long getNumQueryStateMachineOps() {
        return this.numQueryStateMachineOps.value();
    }

    @VisibleForTesting
    public long getNumApplyTransactionsOps() {
        return this.numApplyTransactionOps.value();
    }

    @VisibleForTesting
    public long getNumWriteStateMachineFails() {
        return this.numWriteStateMachineFails.value();
    }

    @VisibleForTesting
    public long getNumWriteDataFails() {
        return this.numWriteDataFails.value();
    }

    @VisibleForTesting
    public long getNumQueryStateMachineFails() {
        return this.numQueryStateMachineFails.value();
    }

    @VisibleForTesting
    public long getNumApplyTransactionsFails() {
        return this.numApplyTransactionFails.value();
    }

    @VisibleForTesting
    public long getNumReadStateMachineFails() {
        return this.numReadStateMachineFails.value();
    }

    @VisibleForTesting
    public long getNumReadStateMachineMissCount() {
        return this.numReadStateMachineMissCount.value();
    }

    @VisibleForTesting
    public long getNumReadStateMachineOps() {
        return this.numReadStateMachineOps.value();
    }

    @VisibleForTesting
    public long getNumBytesWrittenCount() {
        return this.numBytesWrittenCount.value();
    }

    @VisibleForTesting
    public long getNumBytesCommittedCount() {
        return this.numBytesCommittedCount.value();
    }

    public MutableRate getApplyTransactionLatency() {
        return this.applyTransaction;
    }

    public void incPipelineLatency(ContainerProtos.Type type, long latencyNanos) {
        this.opsLatency[type.ordinal()].add(latencyNanos);
        this.transactionLatency.add(latencyNanos);
    }

    public void incNumStartTransactionVerifyFailures() {
        this.numStartTransactionVerifyFailures.incr();
    }

    public void incNumContainerNotOpenVerifyFailures() {
        this.numContainerNotOpenVerifyFailures.incr();
    }

    public void recordApplyTransactionCompletion(long latencyNanos) {
        this.applyTransaction.add(latencyNanos);
    }

    public void recordWriteStateMachineCompletion(long latencyNanos) {
        this.writeStateMachineData.add(latencyNanos);
    }

    public void unRegister() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        ms.unregisterSource(SOURCE_NAME);
    }
}

