/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.transport.server;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.protocol.datanode.proto.XceiverClientProtocolServiceGrpc;
import org.apache.hadoop.ozone.container.common.interfaces.ContainerDispatcher;
import org.apache.ratis.thirdparty.io.grpc.stub.StreamObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcXceiverService
extends XceiverClientProtocolServiceGrpc.XceiverClientProtocolServiceImplBase {
    public static final Logger LOG = LoggerFactory.getLogger(GrpcXceiverService.class);
    private final ContainerDispatcher dispatcher;

    public GrpcXceiverService(ContainerDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    @Override
    public StreamObserver<ContainerProtos.ContainerCommandRequestProto> send(final StreamObserver<ContainerProtos.ContainerCommandResponseProto> responseObserver) {
        return new StreamObserver<ContainerProtos.ContainerCommandRequestProto>(){
            private final AtomicBoolean isClosed = new AtomicBoolean(false);

            @Override
            public void onNext(ContainerProtos.ContainerCommandRequestProto request) {
                try {
                    ContainerProtos.ContainerCommandResponseProto resp = GrpcXceiverService.this.dispatcher.dispatch(request, null);
                    responseObserver.onNext(resp);
                }
                catch (Throwable e) {
                    LOG.error("Got exception when processing ContainerCommandRequestProto {}", (Object)request, (Object)e);
                    responseObserver.onError(e);
                }
            }

            @Override
            public void onError(Throwable t) {
                LOG.error("ContainerCommand send on error. Exception: ", t);
            }

            @Override
            public void onCompleted() {
                if (this.isClosed.compareAndSet(false, true)) {
                    LOG.debug("ContainerCommand send completed");
                    responseObserver.onCompleted();
                }
            }
        };
    }
}

