/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.statemachine.commandhandler;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.ozone.container.common.statemachine.SCMConnectionManager;
import org.apache.hadoop.ozone.container.common.statemachine.StateContext;
import org.apache.hadoop.ozone.container.common.statemachine.commandhandler.CommandHandler;
import org.apache.hadoop.ozone.container.ozoneimpl.OzoneContainer;
import org.apache.hadoop.ozone.protocol.commands.SCMCommand;
import org.apache.hadoop.ozone.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.ozone.shaded.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CommandDispatcher {
    static final Logger LOG = LoggerFactory.getLogger(CommandDispatcher.class);
    private final StateContext context;
    private final Map<StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type, CommandHandler> handlerMap;
    private final OzoneContainer container;
    private final SCMConnectionManager connectionManager;

    private CommandDispatcher(OzoneContainer container, SCMConnectionManager connectionManager, StateContext context, CommandHandler ... handlers) {
        Preconditions.checkNotNull(context);
        Preconditions.checkNotNull(handlers);
        Preconditions.checkArgument(handlers.length > 0);
        Preconditions.checkNotNull(container);
        Preconditions.checkNotNull(connectionManager);
        this.context = context;
        this.container = container;
        this.connectionManager = connectionManager;
        this.handlerMap = new HashMap<StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type, CommandHandler>();
        for (CommandHandler h2 : handlers) {
            if (this.handlerMap.containsKey(h2.getCommandType())) {
                LOG.error("Duplicate handler for the same command. Exiting. Handle key : {}", (Object)h2.getCommandType().getDescriptorForType().getName());
                throw new IllegalArgumentException("Duplicate handler for the same command.");
            }
            this.handlerMap.put(h2.getCommandType(), h2);
        }
    }

    public CommandHandler getCloseContainerHandler() {
        return this.handlerMap.get(StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.closeContainerCommand);
    }

    @VisibleForTesting
    public CommandHandler getDeleteBlocksCommandHandler() {
        return this.handlerMap.get(StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.deleteBlocksCommand);
    }

    public void handle(SCMCommand command) {
        Preconditions.checkNotNull(command);
        CommandHandler handler = this.handlerMap.get(command.getType());
        if (handler != null) {
            handler.handle(command, this.container, this.context, this.connectionManager);
        } else {
            LOG.error("Unknown SCM Command queued. There is no handler for this command. Command: {}", (Object)command.getType().getDescriptorForType().getName());
        }
    }

    public void stop() {
        for (CommandHandler c : this.handlerMap.values()) {
            c.stop();
        }
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private final List<CommandHandler> handlerList = new LinkedList<CommandHandler>();
        private OzoneContainer container;
        private StateContext context;
        private SCMConnectionManager connectionManager;

        public Builder addHandler(CommandHandler handler) {
            Preconditions.checkNotNull(handler);
            this.handlerList.add(handler);
            return this;
        }

        public Builder setContainer(OzoneContainer ozoneContainer) {
            Preconditions.checkNotNull(ozoneContainer);
            this.container = ozoneContainer;
            return this;
        }

        public Builder setConnectionManager(SCMConnectionManager scmConnectionManager) {
            Preconditions.checkNotNull(scmConnectionManager);
            this.connectionManager = scmConnectionManager;
            return this;
        }

        public Builder setContext(StateContext stateContext) {
            Preconditions.checkNotNull(stateContext);
            this.context = stateContext;
            return this;
        }

        public CommandDispatcher build() {
            Preconditions.checkNotNull(this.connectionManager, "Missing connection manager.");
            Preconditions.checkNotNull(this.container, "Missing container.");
            Preconditions.checkNotNull(this.context, "Missing context.");
            Preconditions.checkArgument(this.handlerList.size() > 0);
            return new CommandDispatcher(this.container, this.connectionManager, this.context, this.handlerList.toArray(new CommandHandler[this.handlerList.size()]));
        }
    }
}

