/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.report;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.utils.HddsServerUtil;
import org.apache.hadoop.ozone.container.common.report.ReportPublisher;
import org.apache.hadoop.ozone.shaded.com.google.common.base.Preconditions;

public class NodeReportPublisher
extends ReportPublisher<StorageContainerDatanodeProtocolProtos.NodeReportProto> {
    private Long nodeReportInterval;

    @Override
    protected long getReportFrequency() {
        if (this.nodeReportInterval == null) {
            this.nodeReportInterval = this.getConf().getTimeDuration("hdds.node.report.interval", "60s", TimeUnit.MILLISECONDS);
            long heartbeatFrequency = HddsServerUtil.getScmHeartbeatInterval(this.getConf());
            Preconditions.checkState(heartbeatFrequency <= this.nodeReportInterval, "hdds.node.report.interval cannot be configured lower than heartbeat frequency.");
        }
        return this.nodeReportInterval;
    }

    @Override
    protected StorageContainerDatanodeProtocolProtos.NodeReportProto getReport() throws IOException {
        return this.getContext().getParent().getContainer().getNodeReport();
    }
}

