/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.report;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.utils.HddsServerUtil;
import org.apache.hadoop.ozone.container.common.report.ReportPublisher;
import org.apache.hadoop.ozone.protocol.commands.CommandStatus;
import org.apache.hadoop.ozone.shaded.com.google.common.base.Preconditions;

public class CommandStatusReportPublisher
extends ReportPublisher<StorageContainerDatanodeProtocolProtos.CommandStatusReportsProto> {
    private long cmdStatusReportInterval = -1L;

    @Override
    protected long getReportFrequency() {
        if (this.cmdStatusReportInterval == -1L) {
            this.cmdStatusReportInterval = this.getConf().getTimeDuration("hdds.command.status.report.interval", "60s", TimeUnit.MILLISECONDS);
            long heartbeatFrequency = HddsServerUtil.getScmHeartbeatInterval(this.getConf());
            Preconditions.checkState(heartbeatFrequency <= this.cmdStatusReportInterval, "hdds.command.status.report.interval cannot be configured lower than heartbeat frequency.");
        }
        return this.cmdStatusReportInterval;
    }

    @Override
    protected StorageContainerDatanodeProtocolProtos.CommandStatusReportsProto getReport() {
        Map<Long, CommandStatus> map = this.getContext().getCommandStatusMap();
        Iterator<Long> iterator = map.keySet().iterator();
        StorageContainerDatanodeProtocolProtos.CommandStatusReportsProto.Builder builder = StorageContainerDatanodeProtocolProtos.CommandStatusReportsProto.newBuilder();
        iterator.forEachRemaining(key -> {
            CommandStatus cmdStatus = (CommandStatus)map.get(key);
            if (!cmdStatus.getStatus().equals(StorageContainerDatanodeProtocolProtos.CommandStatus.Status.PENDING)) {
                builder.addCmdStatus(cmdStatus.getProtoBufMessage());
                map.remove(key);
            }
        });
        return builder.getCmdStatusCount() > 0 ? builder.build() : null;
    }
}

