/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.ozone.container.common.helpers.BlockData;
import org.apache.hadoop.ozone.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.ozone.shaded.com.google.common.base.Preconditions;

public class OpenContainerBlockMap {
    private final ConcurrentMap<Long, BlockDataMap> containers = new ConcurrentHashMap<Long, BlockDataMap>();

    public void removeContainer(long containerId) {
        Preconditions.checkState(containerId >= 0L, "Container Id cannot be negative.");
        this.containers.remove(containerId);
    }

    public void addChunk(BlockID blockID, ContainerProtos.ChunkInfo info) {
        Preconditions.checkNotNull(info);
        this.containers.computeIfAbsent(blockID.getContainerID(), id -> new BlockDataMap()).computeIfAbsent(blockID.getLocalID(), id -> new BlockData(blockID)).addChunk(info);
    }

    public void removeChunk(BlockID blockID, ContainerProtos.ChunkInfo chunkInfo) {
        Preconditions.checkNotNull(chunkInfo);
        Preconditions.checkNotNull(blockID);
        Optional.ofNullable(this.containers.get(blockID.getContainerID())).map(blocks -> blocks.get(blockID.getLocalID())).ifPresent(keyData -> keyData.removeChunk(chunkInfo));
    }

    public List<BlockData> getOpenBlocks(long containerId) {
        return Optional.ofNullable(this.containers.get(containerId)).map(BlockDataMap::getAll).orElseGet(Collections::emptyList);
    }

    public void removeFromBlockMap(BlockID blockID) {
        Preconditions.checkNotNull(blockID);
        this.containers.computeIfPresent(blockID.getContainerID(), (containerId, blocks) -> blocks.removeAndGetSize(blockID.getLocalID()) == 0 ? null : blocks);
    }

    public boolean checkIfBlockExists(BlockID blockID) {
        BlockDataMap keyDataMap = (BlockDataMap)this.containers.get(blockID.getContainerID());
        return keyDataMap != null && keyDataMap.get(blockID.getLocalID()) != null;
    }

    @VisibleForTesting
    BlockDataMap getBlockDataMap(long containerId) {
        return (BlockDataMap)this.containers.get(containerId);
    }

    static class BlockDataMap {
        private final ConcurrentMap<Long, BlockData> blocks = new ConcurrentHashMap<Long, BlockData>();

        BlockDataMap() {
        }

        BlockData get(long localId) {
            return (BlockData)this.blocks.get(localId);
        }

        synchronized int removeAndGetSize(long localId) {
            this.blocks.remove(localId);
            return this.blocks.size();
        }

        synchronized BlockData computeIfAbsent(long localId, Function<Long, BlockData> f) {
            return this.blocks.computeIfAbsent(localId, f);
        }

        synchronized List<BlockData> getAll() {
            return new ArrayList<BlockData>(this.blocks.values());
        }
    }
}

