/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.impl;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ozone.shaded.com.google.common.collect.ImmutableList;

public enum ChunkLayOutVersion {
    FILE_PER_CHUNK(1, "One file per chunk"),
    FILE_PER_BLOCK(2, "One file per block");

    private static final ChunkLayOutVersion DEFAULT_LAYOUT;
    private static final List<ChunkLayOutVersion> CHUNK_LAYOUT_VERSIONS;
    private final int version;
    private final String description;

    private ChunkLayOutVersion(int version, String description) {
        this.version = version;
        this.description = description;
    }

    public static ChunkLayOutVersion getChunkLayOutVersion(int chunkVersion) {
        for (ChunkLayOutVersion chunkLayOutVersion : CHUNK_LAYOUT_VERSIONS) {
            if (chunkLayOutVersion.getVersion() != chunkVersion) continue;
            return chunkLayOutVersion;
        }
        return null;
    }

    public static List<ChunkLayOutVersion> getAllVersions() {
        return CHUNK_LAYOUT_VERSIONS;
    }

    public static ChunkLayOutVersion getConfiguredVersion(Configuration conf) {
        try {
            return (ChunkLayOutVersion)conf.getEnum("ozone.scm.chunk.layout", (Enum)DEFAULT_LAYOUT);
        }
        catch (IllegalArgumentException e) {
            return DEFAULT_LAYOUT;
        }
    }

    public int getVersion() {
        return this.version;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return "ChunkLayout:v" + this.version;
    }

    static {
        DEFAULT_LAYOUT = FILE_PER_BLOCK;
        CHUNK_LAYOUT_VERSIONS = ImmutableList.copyOf(ChunkLayOutVersion.values());
    }
}

