/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.helpers;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.io.FilenameUtils;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.StorageContainerException;
import org.apache.hadoop.hdds.scm.protocolPB.ContainerCommandResponseBuilders;
import org.apache.hadoop.ozone.container.common.helpers.DatanodeIdYaml;
import org.apache.hadoop.ozone.container.common.impl.ContainerData;
import org.apache.hadoop.ozone.container.common.impl.ContainerDataYaml;
import org.apache.hadoop.ozone.container.common.impl.ContainerSet;
import org.apache.hadoop.ozone.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.ozone.shaded.org.apache.commons.codec.digest.DigestUtils;
import org.apache.hadoop.ozone.shaded.org.yaml.snakeyaml.Yaml;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ContainerUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerUtils.class);

    private ContainerUtils() {
    }

    public static ContainerProtos.ContainerCommandResponseProto logAndReturnError(Logger log, StorageContainerException ex, ContainerProtos.ContainerCommandRequestProto request) {
        String logInfo = "Operation: {} , Trace ID: {} , Message: {} , Result: {} , StorageContainerException Occurred.";
        log.info(logInfo, new Object[]{request.getCmdType().name(), request.getTraceID(), ex.getMessage(), ex.getResult().getValueDescriptor().getName(), ex});
        return ContainerCommandResponseBuilders.getContainerCommandResponse(request, ex.getResult(), ex.getMessage()).build();
    }

    public static String getContainerNameFromFile(File containerFile) {
        Preconditions.checkNotNull(containerFile);
        return Paths.get(containerFile.getParent(), new String[0]).resolve(FilenameUtils.removeExtension((String)containerFile.getName())).toString();
    }

    public static long getContainerIDFromFile(File containerFile) {
        Preconditions.checkNotNull(containerFile);
        String containerID = ContainerUtils.getContainerNameFromFile(containerFile);
        return Long.parseLong(containerID);
    }

    public static void verifyIsNewContainer(File containerFile) throws FileAlreadyExistsException {
        Logger log = LoggerFactory.getLogger(ContainerSet.class);
        Preconditions.checkNotNull(containerFile, "containerFile Should not be null");
        if (containerFile.getParentFile().exists()) {
            log.error("Container already exists on disk. File: {}", (Object)containerFile.toPath());
            throw new FileAlreadyExistsException("container already exists on disk.");
        }
    }

    public static String getContainerDbFileName(String containerName) {
        return containerName + "-dn-container.db";
    }

    public static synchronized void writeDatanodeDetailsTo(DatanodeDetails datanodeDetails, File path) throws IOException {
        if (path.exists()) {
            if (!path.delete() || !path.createNewFile()) {
                throw new IOException("Unable to overwrite the datanode ID file.");
            }
        } else if (!path.getParentFile().exists() && !path.getParentFile().mkdirs()) {
            throw new IOException("Unable to create datanode ID directories.");
        }
        DatanodeIdYaml.createDatanodeIdFile(datanodeDetails, path);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized DatanodeDetails readDatanodeDetailsFrom(File path) throws IOException {
        if (!path.exists()) {
            throw new IOException("Datanode ID file not found.");
        }
        try {
            return DatanodeIdYaml.readDatanodeIdFile(path);
        }
        catch (IOException e) {
            LOG.warn("Error loading DatanodeDetails yaml from " + path.getAbsolutePath(), (Throwable)e);
            try (FileInputStream in = new FileInputStream(path);){
                DatanodeDetails datanodeDetails = DatanodeDetails.getFromProtoBuf(HddsProtos.DatanodeDetailsProto.parseFrom(in));
                return datanodeDetails;
            }
            catch (IOException io) {
                throw new IOException("Failed to parse DatanodeDetails from " + path.getAbsolutePath(), io);
            }
        }
    }

    public static void verifyChecksum(ContainerData containerData) throws IOException {
        String storedChecksum = containerData.getChecksum();
        Yaml yaml = ContainerDataYaml.getYamlForContainerType(containerData.getContainerType());
        containerData.computeAndSetChecksum(yaml);
        String computedChecksum = containerData.getChecksum();
        if (storedChecksum == null || !storedChecksum.equals(computedChecksum)) {
            throw new StorageContainerException("Container checksum error for ContainerID: " + containerData.getContainerID() + ". " + "\nStored Checksum: " + storedChecksum + "\nExpected Checksum: " + computedChecksum, ContainerProtos.Result.CONTAINER_CHECKSUM_ERROR);
        }
    }

    public static String getChecksum(String containerDataYamlStr) throws StorageContainerException {
        try {
            MessageDigest sha = MessageDigest.getInstance("SHA-256");
            sha.update(containerDataYamlStr.getBytes(ContainerData.CHARSET_ENCODING));
            return DigestUtils.sha256Hex(sha.digest());
        }
        catch (NoSuchAlgorithmException e) {
            throw new StorageContainerException("Unable to create Message Digest, usually this is a java configuration issue.", ContainerProtos.Result.NO_SUCH_ALGORITHM);
        }
    }

    public static File getContainerFile(File containerBaseDir) {
        String containerFilePath = "metadata" + File.separator + ContainerUtils.getContainerID(containerBaseDir) + ".container";
        return new File(containerBaseDir, containerFilePath);
    }

    public static long getContainerID(File containerBaseDir) {
        return Long.parseLong(containerBaseDir.getName());
    }
}

