/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.helpers;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableQuantiles;
import org.apache.hadoop.metrics2.lib.MutableRate;

@InterfaceAudience.Private
@Metrics(about="Storage Container DataNode Metrics", context="dfs")
public class ContainerMetrics {
    public static final String STORAGE_CONTAINER_METRICS = "StorageContainerMetrics";
    @Metric
    private MutableCounterLong numOps;
    private MutableCounterLong[] numOpsArray;
    private MutableCounterLong[] opsBytesArray;
    private MutableRate[] opsLatency;
    private MutableQuantiles[][] opsLatQuantiles;
    private MetricsRegistry registry = null;

    public ContainerMetrics(int[] intervals) {
        int numEnumEntries = ContainerProtos.Type.values().length;
        int len = intervals.length;
        this.numOpsArray = new MutableCounterLong[numEnumEntries];
        this.opsBytesArray = new MutableCounterLong[numEnumEntries];
        this.opsLatency = new MutableRate[numEnumEntries];
        this.opsLatQuantiles = new MutableQuantiles[numEnumEntries][len];
        this.registry = new MetricsRegistry(STORAGE_CONTAINER_METRICS);
        for (int i = 0; i < numEnumEntries; ++i) {
            this.numOpsArray[i] = this.registry.newCounter("num" + ContainerProtos.Type.forNumber(i + 1), "number of " + ContainerProtos.Type.forNumber(i + 1) + " ops", 0L);
            this.opsBytesArray[i] = this.registry.newCounter("bytes" + ContainerProtos.Type.forNumber(i + 1), "bytes used by " + ContainerProtos.Type.forNumber(i + 1) + "op", 0L);
            this.opsLatency[i] = this.registry.newRate("latency" + ContainerProtos.Type.forNumber(i + 1), ContainerProtos.Type.forNumber(i + 1) + " op");
            for (int j = 0; j < len; ++j) {
                int interval = intervals[j];
                String quantileName = ContainerProtos.Type.forNumber(i + 1) + "Nanos" + interval + "s";
                this.opsLatQuantiles[i][j] = this.registry.newQuantiles(quantileName, "latency of Container ops", "ops", "latency", interval);
            }
        }
    }

    public static ContainerMetrics create(Configuration conf) {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        int[] intervals = conf.getInts("dfs.metrics.percentiles.intervals");
        return (ContainerMetrics)ms.register(STORAGE_CONTAINER_METRICS, "Storage Container Node Metrics", (Object)new ContainerMetrics(intervals));
    }

    public static void remove() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        ms.unregisterSource(STORAGE_CONTAINER_METRICS);
    }

    public void incContainerOpsMetrics(ContainerProtos.Type type) {
        this.numOps.incr();
        this.numOpsArray[type.ordinal()].incr();
    }

    public long getContainerOpsMetrics(ContainerProtos.Type type) {
        return this.numOpsArray[type.ordinal()].value();
    }

    public void incContainerOpsLatencies(ContainerProtos.Type type, long latencyNanos) {
        this.opsLatency[type.ordinal()].add(latencyNanos);
        for (MutableQuantiles q : this.opsLatQuantiles[type.ordinal()]) {
            q.add(latencyNanos);
        }
    }

    public void incContainerBytesStats(ContainerProtos.Type type, long bytes) {
        this.opsBytesArray[type.ordinal()].incr(bytes);
    }

    public long getContainerBytesMetrics(ContainerProtos.Type type) {
        return this.opsBytesArray[type.ordinal()].value();
    }
}

