/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.common;

import java.util.HashSet;
import org.apache.hadoop.ozone.common.statemachine.InvalidStateTransitionException;
import org.apache.hadoop.ozone.common.statemachine.StateMachine;
import org.apache.hadoop.ozone.shaded.org.apache.commons.collections.SetUtils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TestStateMachine {
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Test
    public void testStateMachineStates() throws InvalidStateTransitionException {
        HashSet<STATES> finals = new HashSet<STATES>();
        finals.add(STATES.FINAL);
        StateMachine<STATES, EVENTS> stateMachine = new StateMachine<STATES, EVENTS>(STATES.INIT, finals);
        stateMachine.addTransition(STATES.INIT, STATES.CREATING, EVENTS.ALLOCATE);
        stateMachine.addTransition(STATES.CREATING, STATES.OPERATIONAL, EVENTS.CREATE);
        stateMachine.addTransition(STATES.OPERATIONAL, STATES.OPERATIONAL, EVENTS.UPDATE);
        stateMachine.addTransition(STATES.OPERATIONAL, STATES.CLEANUP, EVENTS.DELETE);
        stateMachine.addTransition(STATES.OPERATIONAL, STATES.CLOSED, EVENTS.CLOSE);
        stateMachine.addTransition(STATES.CREATING, STATES.CLEANUP, EVENTS.TIMEOUT);
        Assert.assertEquals((String)"Initial State", (Object)((Object)STATES.INIT), (Object)((Object)stateMachine.getInitialState()));
        Assert.assertTrue((String)"Final States", (boolean)SetUtils.isEqualSet(finals, stateMachine.getFinalStates()));
        Assert.assertEquals((String)"STATE should be OPERATIONAL after being created", (Object)((Object)STATES.OPERATIONAL), (Object)((Object)stateMachine.getNextState(STATES.CREATING, EVENTS.CREATE)));
        Assert.assertEquals((String)"STATE should be OPERATIONAL after being updated", (Object)((Object)STATES.OPERATIONAL), (Object)((Object)stateMachine.getNextState(STATES.OPERATIONAL, EVENTS.UPDATE)));
        Assert.assertEquals((String)"STATE should be CLEANUP after being deleted", (Object)((Object)STATES.CLEANUP), (Object)((Object)stateMachine.getNextState(STATES.OPERATIONAL, EVENTS.DELETE)));
        Assert.assertEquals((String)"STATE should be CLEANUP after being timeout", (Object)((Object)STATES.CLEANUP), (Object)((Object)stateMachine.getNextState(STATES.CREATING, EVENTS.TIMEOUT)));
        Assert.assertEquals((String)"STATE should be CLOSED after being closed", (Object)((Object)STATES.CLOSED), (Object)((Object)stateMachine.getNextState(STATES.OPERATIONAL, EVENTS.CLOSE)));
        this.expectException();
        stateMachine.getNextState(STATES.OPERATIONAL, EVENTS.CREATE);
        this.expectException();
        stateMachine.getNextState(STATES.CREATING, EVENTS.CLOSE);
    }

    private void expectException() {
        this.exception.expect(InvalidStateTransitionException.class);
        this.exception.expectMessage("Invalid event");
    }

    public static enum EVENTS {
        ALLOCATE,
        CREATE,
        UPDATE,
        CLOSE,
        DELETE,
        TIMEOUT;

    }

    public static enum STATES {
        INIT,
        CREATING,
        OPERATIONAL,
        CLOSED,
        CLEANUP,
        FINAL;

    }
}

