/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.common;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.ozone.common.ChunkBuffer;
import org.apache.hadoop.ozone.shaded.com.google.common.collect.ImmutableList;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;

public class TestChunkBufferImplWithByteBufferList {
    @Test
    public void rejectsNullList() {
        List list = null;
        Assertions.assertThrows(IllegalArgumentException.class, () -> ChunkBuffer.wrap(list));
    }

    @Test
    public void acceptsEmptyList() {
        ChunkBuffer subject = ChunkBuffer.wrap(ImmutableList.of());
        TestChunkBufferImplWithByteBufferList.assertEmpty(subject);
        TestChunkBufferImplWithByteBufferList.assertEmpty(subject.duplicate(0, 0));
        Assertions.assertThrows(BufferOverflowException.class, () -> subject.put(ByteBuffer.allocate(1)));
    }

    @Test
    public void rejectsMultipleCurrentBuffers() {
        ByteBuffer b1 = TestChunkBufferImplWithByteBufferList.allocate();
        ByteBuffer b2 = TestChunkBufferImplWithByteBufferList.allocate();
        ByteBuffer b3 = TestChunkBufferImplWithByteBufferList.allocate();
        ImmutableList<ByteBuffer> list = ImmutableList.of(b1, b2, b3);
        b1.position(b1.limit() - 1);
        b2.position(1);
        Assertions.assertThrows(IllegalArgumentException.class, () -> ChunkBuffer.wrap(list));
        b1.position(b1.limit() - 1);
        b2.position(0);
        b3.position(1);
        Assertions.assertThrows(IllegalArgumentException.class, () -> ChunkBuffer.wrap(list));
    }

    private static void assertEmpty(ChunkBuffer subject) {
        Assertions.assertEquals((int)0, (int)subject.position());
        Assertions.assertEquals((int)0, (int)subject.remaining());
        Assertions.assertEquals((int)0, (int)subject.limit());
    }

    private static ByteBuffer allocate() {
        return ByteBuffer.allocate(ThreadLocalRandom.current().nextInt(10, 20));
    }
}

