/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.common;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Properties;
import java.util.UUID;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.ozone.common.InconsistentStorageStateException;
import org.apache.hadoop.ozone.shaded.com.google.common.base.Preconditions;

@InterfaceAudience.Private
public class StorageInfo {
    private Properties properties = new Properties();
    private static final String NODE_TYPE = "nodeType";
    private static final String CLUSTER_ID = "clusterID";
    private static final String CREATION_TIME = "cTime";

    public StorageInfo(HddsProtos.NodeType type, String cid, long cT) throws IOException {
        Preconditions.checkNotNull(type);
        Preconditions.checkNotNull(cid);
        this.properties.setProperty(NODE_TYPE, type.name());
        this.properties.setProperty(CLUSTER_ID, cid);
        this.properties.setProperty(CREATION_TIME, String.valueOf(cT));
    }

    public StorageInfo(HddsProtos.NodeType type, File propertiesFile) throws IOException {
        this.properties = this.readFrom(propertiesFile);
        this.verifyNodeType(type);
        this.verifyClusterId();
        this.verifyCreationTime();
    }

    public HddsProtos.NodeType getNodeType() {
        return HddsProtos.NodeType.valueOf(this.properties.getProperty(NODE_TYPE));
    }

    public String getClusterID() {
        return this.properties.getProperty(CLUSTER_ID);
    }

    public Long getCreationTime() {
        String creationTime = this.properties.getProperty(CREATION_TIME);
        if (creationTime != null) {
            return Long.parseLong(creationTime);
        }
        return null;
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public void setProperty(String key, String value) {
        this.properties.setProperty(key, value);
    }

    public void setClusterId(String clusterId) {
        this.properties.setProperty(CLUSTER_ID, clusterId);
    }

    private void verifyNodeType(HddsProtos.NodeType type) throws InconsistentStorageStateException {
        HddsProtos.NodeType nodeType = this.getNodeType();
        Preconditions.checkNotNull(nodeType);
        if (type != nodeType) {
            throw new InconsistentStorageStateException("Expected NodeType: " + type + ", but found: " + nodeType);
        }
    }

    private void verifyClusterId() throws InconsistentStorageStateException {
        String clusterId = this.getClusterID();
        Preconditions.checkNotNull(clusterId);
        if (clusterId.isEmpty()) {
            throw new InconsistentStorageStateException("Cluster ID not found");
        }
    }

    private void verifyCreationTime() {
        Long creationTime = this.getCreationTime();
        Preconditions.checkNotNull(creationTime);
    }

    public void writeTo(File to) throws IOException {
        try (RandomAccessFile file = new RandomAccessFile(to, "rws");
             FileOutputStream out = new FileOutputStream(file.getFD());){
            file.seek(0L);
            this.properties.store(out, null);
            file.setLength(out.getChannel().position());
        }
    }

    /*
     * Exception decompiling
     */
    private Properties readFrom(File from) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String newClusterID() {
        return "CID-" + UUID.randomUUID().toString();
    }
}

