/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.common;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.hadoop.hdds.scm.ByteStringConversion;
import org.apache.hadoop.ozone.common.ChunkBufferImplWithByteBuffer;
import org.apache.hadoop.ozone.common.ChunkBufferImplWithByteBufferList;
import org.apache.hadoop.ozone.common.IncrementalChunkBuffer;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;

public interface ChunkBuffer {
    public static ChunkBuffer allocate(int capacity) {
        return ChunkBuffer.allocate(capacity, 0);
    }

    public static ChunkBuffer allocate(int capacity, int increment) {
        if (increment > 0 && increment < capacity) {
            return new IncrementalChunkBuffer(capacity, increment, false);
        }
        return new ChunkBufferImplWithByteBuffer(ByteBuffer.allocate(capacity));
    }

    public static ChunkBuffer wrap(ByteBuffer buffer) {
        return new ChunkBufferImplWithByteBuffer(buffer);
    }

    public static ChunkBuffer wrap(List<ByteBuffer> buffers) {
        return new ChunkBufferImplWithByteBufferList(buffers);
    }

    public int position();

    public int remaining();

    public int limit();

    public ChunkBuffer rewind();

    default public boolean hasRemaining() {
        return this.remaining() > 0;
    }

    public ChunkBuffer clear();

    public ChunkBuffer put(ByteBuffer var1);

    default public ChunkBuffer put(byte[] b) {
        return this.put(ByteBuffer.wrap(b));
    }

    default public ChunkBuffer put(byte[] b, int offset, int length) {
        return this.put(ByteBuffer.wrap(b, offset, length));
    }

    default public ChunkBuffer put(ByteString b) {
        return this.put(b.asReadOnlyByteBuffer());
    }

    public ChunkBuffer duplicate(int var1, int var2);

    public Iterable<ByteBuffer> iterate(int var1);

    public List<ByteBuffer> asByteBufferList();

    public long writeTo(GatheringByteChannel var1) throws IOException;

    default public ByteString toByteString(Function<ByteBuffer, ByteString> function) {
        return this.toByteStringImpl(b -> ChunkBuffer.applyAndAssertFunction(b, function, this));
    }

    default public ByteString toByteString() {
        return this.toByteString(ByteStringConversion::safeWrap);
    }

    public ByteString toByteStringImpl(Function<ByteBuffer, ByteString> var1);

    public static void assertInt(int expected, int computed, Supplier<String> prefix) {
        if (expected != computed) {
            throw new IllegalStateException(prefix.get() + ": expected = " + expected + " but computed = " + computed);
        }
    }

    public static ByteString applyAndAssertFunction(ByteBuffer buffer, Function<ByteBuffer, ByteString> function, Object name) {
        int pos = buffer.position();
        int lim = buffer.limit();
        ByteString bytes = function.apply(buffer);
        ChunkBuffer.assertInt(pos, buffer.position(), () -> name + ": Unexpected position");
        ChunkBuffer.assertInt(lim, buffer.limit(), () -> name + ": Unexpected limit");
        return bytes;
    }
}

