/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client.rpc;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.CipherSuite;
import org.apache.hadoop.crypto.CryptoCodec;
import org.apache.hadoop.crypto.CryptoProtocolVersion;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.crypto.key.KeyProviderCryptoExtension;
import org.apache.hadoop.fs.FileEncryptionInfo;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.KMSUtil;

public final class OzoneKMSUtil {
    private static final String UTF8_CSN = StandardCharsets.UTF_8.name();
    private static final String O3_KMS_PREFIX = "ozone-kms-";
    private static String keyProviderUriKeyName = "hadoop.security.key.provider.path";

    private OzoneKMSUtil() {
    }

    public static KeyProvider.KeyVersion decryptEncryptedDataEncryptionKey(FileEncryptionInfo feInfo, KeyProvider keyProvider) throws IOException {
        if (keyProvider == null) {
            throw new IOException("No KeyProvider is configured, cannot access an encrypted file");
        }
        KeyProviderCryptoExtension.EncryptedKeyVersion ekv = KeyProviderCryptoExtension.EncryptedKeyVersion.createForDecryption((String)feInfo.getKeyName(), (String)feInfo.getEzKeyVersionName(), (byte[])feInfo.getIV(), (byte[])feInfo.getEncryptedDataEncryptionKey());
        try {
            KeyProviderCryptoExtension cryptoProvider = KeyProviderCryptoExtension.createKeyProviderCryptoExtension((KeyProvider)keyProvider);
            return cryptoProvider.decryptEncryptedKey(ekv);
        }
        catch (GeneralSecurityException gse) {
            throw new IOException(gse);
        }
    }

    public static Text getKeyProviderMapKey(URI namespaceUri) {
        return new Text(O3_KMS_PREFIX + namespaceUri.getScheme() + "://" + namespaceUri.getAuthority());
    }

    public static String bytes2String(byte[] bytes) {
        return OzoneKMSUtil.bytes2String(bytes, 0, bytes.length);
    }

    private static String bytes2String(byte[] bytes, int offset, int length) {
        try {
            return new String(bytes, offset, length, UTF8_CSN);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("UTF8 encoding is not supported", e);
        }
    }

    public static URI getKeyProviderUri(UserGroupInformation ugi, URI namespaceUri, String kmsUriSrv, Configuration conf) throws IOException {
        byte[] keyProviderUriBytes;
        URI keyProviderUri = null;
        Credentials credentials = ugi.getCredentials();
        Text credsKey = null;
        if (namespaceUri != null && (keyProviderUriBytes = credentials.getSecretKey(credsKey = OzoneKMSUtil.getKeyProviderMapKey(namespaceUri))) != null) {
            keyProviderUri = URI.create(OzoneKMSUtil.bytes2String(keyProviderUriBytes));
        }
        if (keyProviderUri == null) {
            if (kmsUriSrv == null) {
                keyProviderUri = KMSUtil.getKeyProviderUri((Configuration)conf, (String)keyProviderUriKeyName);
            } else if (!kmsUriSrv.isEmpty()) {
                keyProviderUri = URI.create(kmsUriSrv);
            }
        }
        if (keyProviderUri != null && credsKey != null) {
            credentials.addSecretKey(credsKey, DFSUtil.string2Bytes((String)keyProviderUri.toString()));
        }
        return keyProviderUri;
    }

    public static KeyProvider getKeyProvider(Configuration conf, URI serverProviderUri) throws IOException {
        if (serverProviderUri == null) {
            throw new IOException("KMS serverProviderUri is not configured.");
        }
        return KMSUtil.createKeyProviderFromUri((Configuration)conf, (URI)serverProviderUri);
    }

    public static CryptoProtocolVersion getCryptoProtocolVersion(FileEncryptionInfo feInfo) throws IOException {
        CryptoProtocolVersion version = feInfo.getCryptoProtocolVersion();
        if (!CryptoProtocolVersion.supports((CryptoProtocolVersion)version)) {
            throw new IOException("Client does not support specified CryptoProtocolVersion " + version.getDescription() + " version number" + version.getVersion());
        }
        return version;
    }

    public static void checkCryptoProtocolVersion(FileEncryptionInfo feInfo) throws IOException {
        CryptoProtocolVersion version = feInfo.getCryptoProtocolVersion();
        if (!CryptoProtocolVersion.supports((CryptoProtocolVersion)version)) {
            throw new IOException("Client does not support specified CryptoProtocolVersion " + version.getDescription() + " version number" + version.getVersion());
        }
    }

    public static CryptoCodec getCryptoCodec(Configuration conf, FileEncryptionInfo feInfo) throws IOException {
        CipherSuite suite = feInfo.getCipherSuite();
        if (suite.equals((Object)CipherSuite.UNKNOWN)) {
            throw new IOException("NameNode specified unknown CipherSuite with ID " + suite.getUnknownValue() + ", cannot instantiate CryptoCodec.");
        }
        CryptoCodec codec = CryptoCodec.getInstance((Configuration)conf, (CipherSuite)suite);
        if (codec == null) {
            throw new OMException("No configuration found for the cipher suite " + suite.getConfigSuffix() + " prefixed with " + "hadoop.security.crypto.codec.classes. Please see the" + " example configuration hadoop.security.crypto.codec.classes." + "EXAMPLE CIPHER SUITE at core-default.xml for details.", OMException.ResultCodes.UNKNOWN_CIPHER_SUITE);
        }
        return codec;
    }
}

