/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client;

import java.io.IOException;
import java.time.Instant;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.client.OzoneQuota;
import org.apache.hadoop.hdds.scm.client.HddsClientUtils;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.client.BucketArgs;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.protocol.ClientProtocol;
import org.apache.hadoop.ozone.om.helpers.WithMetadata;
import org.apache.hadoop.ozone.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.ozone.shaded.com.google.common.base.Preconditions;

public class OzoneVolume
extends WithMetadata {
    private final ClientProtocol proxy;
    private final String name;
    private String admin;
    private String owner;
    private long quotaInBytes;
    private Instant creationTime;
    private List<OzoneAcl> acls;
    private int listCacheSize;

    public OzoneVolume(Configuration conf, ClientProtocol proxy, String name, String admin, String owner, long quotaInBytes, long creationTime, List<OzoneAcl> acls, Map<String, String> metadata) {
        Preconditions.checkNotNull(proxy, "Client proxy is not set.");
        this.proxy = proxy;
        this.name = name;
        this.admin = admin;
        this.owner = owner;
        this.quotaInBytes = quotaInBytes;
        this.creationTime = Instant.ofEpochMilli(creationTime);
        this.acls = acls;
        this.listCacheSize = HddsClientUtils.getListCacheSize(conf);
        this.metadata = metadata;
    }

    public OzoneVolume(Configuration conf, ClientProtocol proxy, String name, String admin, String owner, long quotaInBytes, long creationTime, List<OzoneAcl> acls) {
        this(conf, proxy, name, admin, owner, quotaInBytes, creationTime, acls, new HashMap<String, String>());
    }

    @VisibleForTesting
    protected OzoneVolume(String name, String admin, String owner, long quotaInBytes, long creationTime, List<OzoneAcl> acls) {
        this.proxy = null;
        this.name = name;
        this.admin = admin;
        this.owner = owner;
        this.quotaInBytes = quotaInBytes;
        this.creationTime = Instant.ofEpochMilli(creationTime);
        this.acls = acls;
        this.metadata = new HashMap();
    }

    public String getName() {
        return this.name;
    }

    public String getAdmin() {
        return this.admin;
    }

    public String getOwner() {
        return this.owner;
    }

    public long getQuota() {
        return this.quotaInBytes;
    }

    public Instant getCreationTime() {
        return this.creationTime;
    }

    public List<OzoneAcl> getAcls() {
        return this.acls;
    }

    public void setOwner(String owner) throws IOException {
        this.proxy.setVolumeOwner(this.name, owner);
        this.owner = owner;
    }

    public void setQuota(OzoneQuota quota) throws IOException {
        this.proxy.setVolumeQuota(this.name, quota);
        this.quotaInBytes = quota.sizeInBytes();
    }

    public void createBucket(String bucketName) throws IOException {
        this.proxy.createBucket(this.name, bucketName);
    }

    public void createBucket(String bucketName, BucketArgs bucketArgs) throws IOException {
        this.proxy.createBucket(this.name, bucketName, bucketArgs);
    }

    public OzoneBucket getBucket(String bucketName) throws IOException {
        OzoneBucket bucket = this.proxy.getBucketDetails(this.name, bucketName);
        return bucket;
    }

    public Iterator<? extends OzoneBucket> listBuckets(String bucketPrefix) {
        return this.listBuckets(bucketPrefix, null);
    }

    public Iterator<? extends OzoneBucket> listBuckets(String bucketPrefix, String prevBucket) {
        return new BucketIterator(bucketPrefix, prevBucket);
    }

    public void deleteBucket(String bucketName) throws IOException {
        this.proxy.deleteBucket(this.name, bucketName);
    }

    private class BucketIterator
    implements Iterator<OzoneBucket> {
        private String bucketPrefix = null;
        private Iterator<OzoneBucket> currentIterator;
        private OzoneBucket currentValue;

        BucketIterator(String bucketPrefix, String prevBucket) {
            this.bucketPrefix = bucketPrefix;
            this.currentValue = null;
            this.currentIterator = this.getNextListOfBuckets(prevBucket).iterator();
        }

        @Override
        public boolean hasNext() {
            if (!this.currentIterator.hasNext() && this.currentValue != null) {
                this.currentIterator = this.getNextListOfBuckets(this.currentValue.getName()).iterator();
            }
            return this.currentIterator.hasNext();
        }

        @Override
        public OzoneBucket next() {
            if (this.hasNext()) {
                this.currentValue = this.currentIterator.next();
                return this.currentValue;
            }
            throw new NoSuchElementException();
        }

        private List<OzoneBucket> getNextListOfBuckets(String prevBucket) {
            try {
                return OzoneVolume.this.proxy.listBuckets(OzoneVolume.this.name, this.bucketPrefix, prevBucket, OzoneVolume.this.listCacheSize);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

