/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.protocol.ClientProtocol;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OzoneClientInvocationHandler
implements InvocationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(OzoneClient.class);
    private final ClientProtocol target;

    public OzoneClientInvocationHandler(ClientProtocol target) {
        this.target = target;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        LOG.trace("Invoking method {} on target {}", (Object)method, (Object)this.target);
        try {
            long startTime = Time.monotonicNow();
            Object result = method.invoke((Object)this.target, args);
            LOG.debug("Call: {} took {} ms", (Object)method, (Object)(Time.monotonicNow() - startTime));
            return result;
        }
        catch (InvocationTargetException iEx) {
            throw iEx.getCause();
        }
    }
}

