/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneClientInvocationHandler;
import org.apache.hadoop.ozone.client.protocol.ClientProtocol;
import org.apache.hadoop.ozone.client.rpc.RpcClient;
import org.apache.hadoop.ozone.shaded.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OzoneClientFactory {
    private static final Logger LOG = LoggerFactory.getLogger(OzoneClientFactory.class);

    private OzoneClientFactory() {
    }

    public static OzoneClient getRpcClient() throws IOException {
        LOG.info("Creating OzoneClient with default configuration.");
        return OzoneClientFactory.getRpcClient(new OzoneConfiguration());
    }

    public static OzoneClient getRpcClient(String omHost, Integer omRpcPort, Configuration config) throws IOException {
        Preconditions.checkNotNull(omHost);
        Preconditions.checkNotNull(omRpcPort);
        Preconditions.checkNotNull(config);
        config.set("ozone.om.address", omHost + ":" + omRpcPort);
        return OzoneClientFactory.getRpcClient(OzoneClientFactory.getClientProtocol(config), config);
    }

    public static OzoneClient getRpcClient(String omServiceId, Configuration config) throws IOException {
        Preconditions.checkNotNull(omServiceId);
        Preconditions.checkNotNull(config);
        if (OmUtils.isOmHAServiceId(config, omServiceId)) {
            return OzoneClientFactory.getRpcClient(OzoneClientFactory.getClientProtocol(config, omServiceId), config);
        }
        throw new IOException("Service ID specified does not match with ozone.om.service.ids defined in the configuration. Configured ozone.om.service.ids are" + config.getTrimmedStringCollection("ozone.om.service.ids"));
    }

    public static OzoneClient getRpcClient(Configuration config) throws IOException {
        Preconditions.checkNotNull(config);
        if (OmUtils.isServiceIdsDefined(config)) {
            throw new IOException("Following ServiceID's " + config.getTrimmedStringCollection("ozone.om.service.ids") + " are" + " defined in the configuration. Use the method getRpcClient which " + "takes serviceID and configuration as param");
        }
        return OzoneClientFactory.getRpcClient(OzoneClientFactory.getClientProtocol(config), config);
    }

    private static OzoneClient getRpcClient(ClientProtocol clientProtocol, Configuration config) {
        OzoneClientInvocationHandler clientHandler = new OzoneClientInvocationHandler(clientProtocol);
        ClientProtocol proxy = (ClientProtocol)Proxy.newProxyInstance(OzoneClientInvocationHandler.class.getClassLoader(), new Class[]{ClientProtocol.class}, (InvocationHandler)clientHandler);
        return new OzoneClient(config, proxy);
    }

    private static ClientProtocol getClientProtocol(Configuration config) throws IOException {
        return OzoneClientFactory.getClientProtocol(config, null);
    }

    private static ClientProtocol getClientProtocol(Configuration config, String omServiceId) throws IOException {
        try {
            return new RpcClient(config, omServiceId);
        }
        catch (Exception e) {
            String message = "Couldn't create RpcClient protocol";
            LOG.error("Couldn't create RpcClient protocol exception: ", (Throwable)e);
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new IOException("Couldn't create RpcClient protocol", e);
        }
    }
}

