/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client;

import java.io.Closeable;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ozone.client.ObjectStore;
import org.apache.hadoop.ozone.client.protocol.ClientProtocol;
import org.apache.hadoop.ozone.shaded.com.google.common.annotations.VisibleForTesting;

public class OzoneClient
implements Closeable {
    private final ClientProtocol proxy;
    private final ObjectStore objectStore;

    public OzoneClient(Configuration conf, ClientProtocol proxy) {
        this.proxy = proxy;
        this.objectStore = new ObjectStore(conf, this.proxy);
    }

    @VisibleForTesting
    protected OzoneClient(ObjectStore objectStore) {
        this.objectStore = objectStore;
        this.proxy = null;
    }

    public ObjectStore getObjectStore() {
        return this.objectStore;
    }

    @Override
    public void close() throws IOException {
        this.proxy.close();
    }
}

