/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.hdds.scm.client.HddsClientUtils;
import org.apache.hadoop.hdds.tracing.TracingUtil;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneVolume;
import org.apache.hadoop.ozone.client.VolumeArgs;
import org.apache.hadoop.ozone.client.protocol.ClientProtocol;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.S3SecretValue;
import org.apache.hadoop.ozone.security.OzoneTokenIdentifier;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.ozone.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.ozone.shaded.com.google.common.base.Strings;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;

public class ObjectStore {
    private final ClientProtocol proxy;
    private int listCacheSize;

    public ObjectStore(Configuration conf, ClientProtocol proxy) {
        this.proxy = TracingUtil.createProxy(proxy, ClientProtocol.class, conf);
        this.listCacheSize = HddsClientUtils.getListCacheSize(conf);
    }

    @VisibleForTesting
    protected ObjectStore() {
        this.proxy = null;
    }

    @VisibleForTesting
    public ClientProtocol getClientProxy() {
        return this.proxy;
    }

    public void createVolume(String volumeName) throws IOException {
        this.proxy.createVolume(volumeName);
    }

    public void createVolume(String volumeName, VolumeArgs volumeArgs) throws IOException {
        this.proxy.createVolume(volumeName, volumeArgs);
    }

    public void createS3Bucket(String userName, String s3BucketName) throws IOException {
        this.proxy.createS3Bucket(userName, s3BucketName);
    }

    public void deleteS3Bucket(String bucketName) throws IOException {
        this.proxy.deleteS3Bucket(bucketName);
    }

    public String getOzoneBucketMapping(String s3BucketName) throws IOException {
        return this.proxy.getOzoneBucketMapping(s3BucketName);
    }

    public String getOzoneVolumeName(String s3BucketName) throws IOException {
        String mapping = this.getOzoneBucketMapping(s3BucketName);
        return mapping.split("/")[0];
    }

    public String getOzoneBucketName(String s3BucketName) throws IOException {
        String mapping = this.getOzoneBucketMapping(s3BucketName);
        return mapping.split("/")[1];
    }

    public OzoneVolume getVolume(String volumeName) throws IOException {
        OzoneVolume volume = this.proxy.getVolumeDetails(volumeName);
        return volume;
    }

    public S3SecretValue getS3Secret(String kerberosID) throws IOException {
        return this.proxy.getS3Secret(kerberosID);
    }

    public Iterator<? extends OzoneBucket> listS3Buckets(String userName, String bucketPrefix) {
        return this.listS3Buckets(userName, bucketPrefix, null);
    }

    public Iterator<? extends OzoneBucket> listS3Buckets(String userName, String bucketPrefix, String prevBucket) {
        return new S3BucketIterator(userName, bucketPrefix, prevBucket);
    }

    public Iterator<? extends OzoneVolume> listVolumes(String volumePrefix) throws IOException {
        return this.listVolumes(volumePrefix, null);
    }

    public Iterator<? extends OzoneVolume> listVolumes(String volumePrefix, String prevVolume) throws IOException {
        return new VolumeIterator(null, volumePrefix, prevVolume);
    }

    public Iterator<? extends OzoneVolume> listVolumesByUser(String user, String volumePrefix, String prevVolume) throws IOException {
        if (Strings.isNullOrEmpty(user)) {
            user = UserGroupInformation.getCurrentUser().getShortUserName();
        }
        return new VolumeIterator(user, volumePrefix, prevVolume);
    }

    public void deleteVolume(String volumeName) throws IOException {
        this.proxy.deleteVolume(volumeName);
    }

    public KeyProvider getKeyProvider() throws IOException {
        return this.proxy.getKeyProvider();
    }

    public URI getKeyProviderUri() throws IOException {
        return this.proxy.getKeyProviderUri();
    }

    public Token<OzoneTokenIdentifier> getDelegationToken(Text renewer) throws IOException {
        return this.proxy.getDelegationToken(renewer);
    }

    public long renewDelegationToken(Token<OzoneTokenIdentifier> token) throws IOException {
        return this.proxy.renewDelegationToken(token);
    }

    public void cancelDelegationToken(Token<OzoneTokenIdentifier> token) throws IOException {
        this.proxy.cancelDelegationToken(token);
    }

    public String getCanonicalServiceName() {
        return this.proxy.getCanonicalServiceName();
    }

    public boolean addAcl(OzoneObj obj, OzoneAcl acl) throws IOException {
        return this.proxy.addAcl(obj, acl);
    }

    public boolean removeAcl(OzoneObj obj, OzoneAcl acl) throws IOException {
        return this.proxy.removeAcl(obj, acl);
    }

    public boolean setAcl(OzoneObj obj, List<OzoneAcl> acls) throws IOException {
        return this.proxy.setAcl(obj, acls);
    }

    public List<OzoneAcl> getAcl(OzoneObj obj) throws IOException {
        return this.proxy.getAcl(obj);
    }

    public class S3BucketIterator
    implements Iterator<OzoneBucket> {
        private String bucketPrefix = null;
        private String userName;
        private Iterator<OzoneBucket> currentIterator;
        private OzoneBucket currentValue;

        public S3BucketIterator(String user, String bucketPrefix, String prevBucket) {
            Objects.requireNonNull(user);
            this.userName = user;
            this.bucketPrefix = bucketPrefix;
            this.currentValue = null;
            this.currentIterator = this.getNextListOfS3Buckets(prevBucket).iterator();
        }

        @Override
        public boolean hasNext() {
            if (!this.currentIterator.hasNext()) {
                this.currentIterator = this.getNextListOfS3Buckets(this.currentValue != null ? this.currentValue.getName() : null).iterator();
            }
            return this.currentIterator.hasNext();
        }

        @Override
        public OzoneBucket next() {
            if (this.hasNext()) {
                this.currentValue = this.currentIterator.next();
                return this.currentValue;
            }
            throw new NoSuchElementException();
        }

        private List<OzoneBucket> getNextListOfS3Buckets(String prevBucket) {
            try {
                return ObjectStore.this.proxy.listS3Buckets(this.userName, this.bucketPrefix, prevBucket, ObjectStore.this.listCacheSize);
            }
            catch (OMException e) {
                if (e.getResult() == OMException.ResultCodes.VOLUME_NOT_FOUND) {
                    return new ArrayList<OzoneBucket>();
                }
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private class VolumeIterator
    implements Iterator<OzoneVolume> {
        private String user = null;
        private String volPrefix = null;
        private Iterator<OzoneVolume> currentIterator;
        private OzoneVolume currentValue;

        VolumeIterator(String user, String volPrefix, String prevVolume) {
            this.user = user;
            this.volPrefix = volPrefix;
            this.currentValue = null;
            this.currentIterator = this.getNextListOfVolumes(prevVolume).iterator();
        }

        @Override
        public boolean hasNext() {
            if (!this.currentIterator.hasNext() && this.currentValue != null) {
                this.currentIterator = this.getNextListOfVolumes(this.currentValue.getName()).iterator();
            }
            return this.currentIterator.hasNext();
        }

        @Override
        public OzoneVolume next() {
            if (this.hasNext()) {
                this.currentValue = this.currentIterator.next();
                return this.currentValue;
            }
            throw new NoSuchElementException();
        }

        private List<OzoneVolume> getNextListOfVolumes(String prevVolume) {
            try {
                if (this.user != null) {
                    return ObjectStore.this.proxy.listVolumes(this.user, this.volPrefix, prevVolume, ObjectStore.this.listCacheSize);
                }
                return ObjectStore.this.proxy.listVolumes(this.volPrefix, prevVolume, ObjectStore.this.listCacheSize);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

