/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.audit;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.ozone.audit.AuditEventStatus;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.audit.AuditLoggerType;
import org.apache.hadoop.ozone.audit.AuditMessage;
import org.apache.hadoop.ozone.audit.DummyAction;
import org.apache.hadoop.ozone.audit.DummyEntity;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestOzoneAuditLogger {
    private static final Logger LOG = LoggerFactory.getLogger((String)TestOzoneAuditLogger.class.getName());
    private static final AuditLogger AUDIT;
    private static final Map<String, String> PARAMS;
    private static final String IP_ADDRESS = "192.168.0.1";
    private static final String USER = "john";
    private static final AuditMessage WRITE_FAIL_MSG;
    private static final AuditMessage WRITE_SUCCESS_MSG;
    private static final AuditMessage READ_FAIL_MSG;
    private static final AuditMessage READ_SUCCESS_MSG;

    @AfterClass
    public static void tearDown() {
        File file = new File("audit.log");
        if (FileUtils.deleteQuietly((File)file)) {
            LOG.info("{} has been deleted as all tests have completed.", (Object)file.getName());
        } else {
            LOG.info("audit.log could not be deleted.");
        }
    }

    @Test
    public void verifyDefaultLogLevelForSuccess() throws IOException {
        AUDIT.logWriteSuccess(WRITE_SUCCESS_MSG);
        String expected = "INFO  | OMAudit | " + WRITE_SUCCESS_MSG.getFormattedMessage();
        this.verifyLog(expected);
    }

    @Test
    public void verifyDefaultLogLevelForFailure() throws IOException {
        AUDIT.logWriteFailure(WRITE_FAIL_MSG);
        String expected = "ERROR | OMAudit | " + WRITE_FAIL_MSG.getFormattedMessage();
        this.verifyLog(expected);
    }

    @Test
    public void messageIncludesAllParts() {
        String message = WRITE_FAIL_MSG.getFormattedMessage();
        Assert.assertTrue((String)message, (boolean)message.contains(USER));
        Assert.assertTrue((String)message, (boolean)message.contains(IP_ADDRESS));
        Assert.assertTrue((String)message, (boolean)message.contains(DummyAction.CREATE_VOLUME.name()));
        Assert.assertTrue((String)message, (boolean)message.contains(PARAMS.toString()));
        Assert.assertTrue((String)message, (boolean)message.contains(AuditEventStatus.FAILURE.getStatus()));
    }

    @Test
    public void notLogReadEvents() throws IOException {
        AUDIT.logReadSuccess(READ_SUCCESS_MSG);
        AUDIT.logReadFailure(READ_FAIL_MSG);
        this.verifyNoLog();
    }

    private void verifyLog(String expected) throws IOException {
        File file = new File("audit.log");
        List lines = FileUtils.readLines((File)file, (String)null);
        int retry = 5;
        for (int i = 0; lines.isEmpty() && i < 5; ++i) {
            lines = FileUtils.readLines((File)file, (String)null);
            try {
                Thread.sleep(500 * (i + 1));
                continue;
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                break;
            }
        }
        Assert.assertTrue((lines.size() != 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)expected.equalsIgnoreCase((String)lines.get(0)));
        lines.clear();
        FileUtils.writeLines((File)file, (Collection)lines, (boolean)false);
    }

    private void verifyNoLog() throws IOException {
        File file = new File("audit.log");
        List lines = FileUtils.readLines((File)file, (String)null);
        Assert.assertEquals((long)0L, (long)lines.size());
    }

    static {
        System.setProperty("log4j.configurationFile", "auditlog.properties");
        AUDIT = new AuditLogger(AuditLoggerType.OMLOGGER);
        PARAMS = new DummyEntity().toAuditMap();
        WRITE_FAIL_MSG = new AuditMessage.Builder().setUser(USER).atIp(IP_ADDRESS).forOperation(DummyAction.CREATE_VOLUME).withParams(PARAMS).withResult(AuditEventStatus.FAILURE).withException(null).build();
        WRITE_SUCCESS_MSG = new AuditMessage.Builder().setUser(USER).atIp(IP_ADDRESS).forOperation(DummyAction.CREATE_VOLUME).withParams(PARAMS).withResult(AuditEventStatus.SUCCESS).withException(null).build();
        READ_FAIL_MSG = new AuditMessage.Builder().setUser(USER).atIp(IP_ADDRESS).forOperation(DummyAction.READ_VOLUME).withParams(PARAMS).withResult(AuditEventStatus.FAILURE).withException(null).build();
        READ_SUCCESS_MSG = new AuditMessage.Builder().setUser(USER).atIp(IP_ADDRESS).forOperation(DummyAction.READ_VOLUME).withParams(PARAMS).withResult(AuditEventStatus.SUCCESS).withException(null).build();
    }
}

