/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.utils.db.DBCheckpoint;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.RepeatedOmKeyInfo;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.shaded.com.google.common.base.Joiner;
import org.apache.hadoop.ozone.shaded.org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.hadoop.ozone.shaded.org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.hadoop.ozone.shaded.org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.hadoop.ozone.shaded.org.apache.commons.compress.compressors.CompressorException;
import org.apache.hadoop.ozone.shaded.org.apache.commons.compress.compressors.CompressorOutputStream;
import org.apache.hadoop.ozone.shaded.org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.hadoop.ozone.shaded.org.apache.commons.compress.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OmUtils {
    public static final Logger LOG = LoggerFactory.getLogger(OmUtils.class);
    private static final SecureRandom SRAND = new SecureRandom();
    private static byte[] randomBytes = new byte[32];

    private OmUtils() {
    }

    public static InetSocketAddress getOmAddress(Configuration conf) {
        return NetUtils.createSocketAddr((String)OmUtils.getOmRpcAddress(conf));
    }

    public static Map<String, List<InetSocketAddress>> getOmHAAddressesById(Configuration conf) {
        HashMap<String, List<InetSocketAddress>> result = new HashMap<String, List<InetSocketAddress>>();
        for (String serviceId : conf.getTrimmedStringCollection("ozone.om.service.ids")) {
            if (!result.containsKey(serviceId)) {
                result.put(serviceId, new ArrayList());
            }
            for (String nodeId : OmUtils.getOMNodeIds(conf, serviceId)) {
                String rpcAddr = OmUtils.getOmRpcAddress(conf, OmUtils.addKeySuffixes("ozone.om.address", serviceId, nodeId));
                if (rpcAddr != null) {
                    ((List)result.get(serviceId)).add(NetUtils.createSocketAddr((String)rpcAddr));
                    continue;
                }
                LOG.warn("Address undefined for nodeId: {} for service {}", (Object)nodeId, (Object)serviceId);
            }
        }
        return result;
    }

    public static String getOmRpcAddress(Configuration conf) {
        Optional<String> host = HddsUtils.getHostNameFromConfigKeys(conf, "ozone.om.address");
        return host.orElse("0.0.0.0") + ":" + OmUtils.getOmRpcPort(conf);
    }

    public static String getOmRpcAddress(Configuration conf, String confKey) {
        Optional<String> host = HddsUtils.getHostNameFromConfigKeys(conf, confKey);
        if (host.isPresent()) {
            return host.get() + ":" + OmUtils.getOmRpcPort(conf, confKey);
        }
        return null;
    }

    public static InetSocketAddress getOmAddressForClients(Configuration conf) {
        Optional<String> host = HddsUtils.getHostNameFromConfigKeys(conf, "ozone.om.address");
        if (!host.isPresent()) {
            throw new IllegalArgumentException("ozone.om.address must be defined. See https://wiki.apache.org/hadoop/Ozone#Configuration for details on configuring Ozone.");
        }
        return NetUtils.createSocketAddr((String)(host.get() + ":" + OmUtils.getOmRpcPort(conf)));
    }

    public static boolean isServiceIdsDefined(Configuration conf) {
        String val = conf.get("ozone.om.service.ids");
        return val != null && val.length() > 0;
    }

    public static boolean isOmHAServiceId(Configuration conf, String serviceId) {
        Collection omServiceIds = conf.getTrimmedStringCollection("ozone.om.service.ids");
        return omServiceIds.contains(serviceId);
    }

    public static int getOmRpcPort(Configuration conf) {
        return HddsUtils.getPortNumberFromConfigKeys(conf, "ozone.om.address").orElse(9862);
    }

    public static int getOmRpcPort(Configuration conf, String confKey) {
        return HddsUtils.getPortNumberFromConfigKeys(conf, confKey).orElse(9862);
    }

    public static int getOmRestPort(Configuration conf) {
        return HddsUtils.getPortNumberFromConfigKeys(conf, "ozone.om.http-address").orElse(9874);
    }

    public static boolean isReadOnly(OzoneManagerProtocolProtos.OMRequest omRequest) {
        OzoneManagerProtocolProtos.Type cmdType = omRequest.getCmdType();
        switch (cmdType) {
            case CheckVolumeAccess: 
            case InfoVolume: 
            case ListVolume: 
            case InfoBucket: 
            case ListBuckets: 
            case LookupKey: 
            case ListKeys: 
            case ListTrash: 
            case RecoverTrash: 
            case InfoS3Bucket: 
            case ListS3Buckets: 
            case ServiceList: 
            case ListMultiPartUploadParts: 
            case GetFileStatus: 
            case LookupFile: 
            case ListStatus: 
            case GetAcl: 
            case DBUpdates: 
            case ListMultipartUploads: {
                return true;
            }
            case CreateVolume: 
            case SetVolumeProperty: 
            case DeleteVolume: 
            case CreateBucket: 
            case SetBucketProperty: 
            case DeleteBucket: 
            case CreateKey: 
            case RenameKey: 
            case DeleteKey: 
            case CommitKey: 
            case AllocateBlock: 
            case CreateS3Bucket: 
            case DeleteS3Bucket: 
            case InitiateMultiPartUpload: 
            case CommitMultiPartUpload: 
            case CompleteMultiPartUpload: 
            case AbortMultiPartUpload: 
            case GetS3Secret: 
            case GetDelegationToken: 
            case RenewDelegationToken: 
            case CancelDelegationToken: 
            case CreateDirectory: 
            case CreateFile: 
            case RemoveAcl: 
            case SetAcl: 
            case AddAcl: 
            case PurgeKeys: {
                return false;
            }
        }
        LOG.error("CmdType {} is not categorized as readOnly or not.", (Object)cmdType);
        return false;
    }

    public static byte[] getMD5Digest(String input) throws IOException {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            return md.digest(input.getBytes(StandardCharsets.UTF_8));
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IOException("Error creating an instance of MD5 digest.\nThis could possibly indicate a faulty JRE");
        }
    }

    public static byte[] getSHADigest() throws IOException {
        try {
            SRAND.nextBytes(randomBytes);
            MessageDigest sha = MessageDigest.getInstance("SHA-256");
            return sha.digest(randomBytes);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IOException("Error creating an instance of SHA-256 digest.\nThis could possibly indicate a faulty JRE");
        }
    }

    private static String addSuffix(String key, String suffix) {
        if (suffix == null || suffix.isEmpty()) {
            return key;
        }
        assert (!suffix.startsWith(".")) : "suffix '" + suffix + "' should not already have '.' prepended.";
        return key + "." + suffix;
    }

    private static String concatSuffixes(String ... suffixes) {
        if (suffixes == null) {
            return null;
        }
        return Joiner.on(".").skipNulls().join(suffixes);
    }

    public static String addKeySuffixes(String key, String ... suffixes) {
        String keySuffix = OmUtils.concatSuffixes(suffixes);
        return OmUtils.addSuffix(key, keySuffix);
    }

    public static boolean isAddressLocal(InetSocketAddress addr) {
        return NetUtils.isLocalAddress((InetAddress)addr.getAddress());
    }

    public static Collection<String> getOMNodeIds(Configuration conf, String omServiceId) {
        String key = OmUtils.addSuffix("ozone.om.nodes", omServiceId);
        return conf.getTrimmedStringCollection(key);
    }

    public static Collection<String> emptyAsSingletonNull(Collection<String> coll) {
        if (coll == null || coll.isEmpty()) {
            return Collections.singletonList(null);
        }
        return coll;
    }

    public static void writeOmDBCheckpointToStream(DBCheckpoint checkpoint, OutputStream destination) throws IOException {
        try (CompressorOutputStream gzippedOut = new CompressorStreamFactory().createCompressorOutputStream("gz", destination);
             TarArchiveOutputStream archiveOutputStream = new TarArchiveOutputStream(gzippedOut);){
            Path checkpointPath = checkpoint.getCheckpointLocation();
            try (Stream<Path> files = Files.list(checkpointPath);){
                for (Path path : files.collect(Collectors.toList())) {
                    Path fileName;
                    if (path == null || (fileName = path.getFileName()) == null) continue;
                    OmUtils.includeFile(path.toFile(), fileName.toString(), archiveOutputStream);
                }
            }
        }
        catch (CompressorException e) {
            throw new IOException("Can't compress the checkpoint: " + checkpoint.getCheckpointLocation(), e);
        }
    }

    private static void includeFile(File file, String entryName, ArchiveOutputStream archiveOutputStream) throws IOException {
        ArchiveEntry archiveEntry = archiveOutputStream.createArchiveEntry(file, entryName);
        archiveOutputStream.putArchiveEntry(archiveEntry);
        try (FileInputStream fis = new FileInputStream(file);){
            IOUtils.copy(fis, archiveOutputStream);
        }
        archiveOutputStream.closeArchiveEntry();
    }

    public static String getConfSuffixedWithOMNodeId(Configuration conf, String confKey, String omServiceID, String omNodeId) {
        String suffixedConfKey = OmUtils.addKeySuffixes(confKey, omServiceID, omNodeId);
        String confValue = conf.getTrimmed(suffixedConfKey);
        if (StringUtils.isNotEmpty((CharSequence)confValue)) {
            return confValue;
        }
        return null;
    }

    public static String getHttpAddressForOMPeerNode(Configuration conf, String omServiceId, String omNodeId, String omNodeHostAddr) {
        Optional<String> bindHost = HddsUtils.getHostNameFromConfigKeys(conf, OmUtils.addKeySuffixes("ozone.om.http-bind-host", omServiceId, omNodeId));
        OptionalInt addressPort = HddsUtils.getPortNumberFromConfigKeys(conf, OmUtils.addKeySuffixes("ozone.om.http-address", omServiceId, omNodeId));
        Optional<String> addressHost = HddsUtils.getHostNameFromConfigKeys(conf, OmUtils.addKeySuffixes("ozone.om.http-address", omServiceId, omNodeId));
        String hostName = bindHost.orElse(addressHost.orElse(omNodeHostAddr));
        return hostName + ":" + addressPort.orElse(9874);
    }

    public static String getHttpsAddressForOMPeerNode(Configuration conf, String omServiceId, String omNodeId, String omNodeHostAddr) {
        Optional<String> bindHost = HddsUtils.getHostNameFromConfigKeys(conf, OmUtils.addKeySuffixes("ozone.om.https-bind-host", omServiceId, omNodeId));
        OptionalInt addressPort = HddsUtils.getPortNumberFromConfigKeys(conf, OmUtils.addKeySuffixes("ozone.om.https-address", omServiceId, omNodeId));
        Optional<String> addressHost = HddsUtils.getHostNameFromConfigKeys(conf, OmUtils.addKeySuffixes("ozone.om.https-address", omServiceId, omNodeId));
        String hostName = bindHost.orElse(addressHost.orElse(omNodeHostAddr));
        return hostName + ":" + addressPort.orElse(9875);
    }

    public static File createOMDir(String dirPath) {
        File dirFile = new File(dirPath);
        if (!dirFile.mkdirs() && !dirFile.exists()) {
            throw new IllegalArgumentException("Unable to create path: " + dirFile);
        }
        return dirFile;
    }

    public static RepeatedOmKeyInfo prepareKeyForDelete(OmKeyInfo keyInfo, RepeatedOmKeyInfo repeatedOmKeyInfo, long trxnLogIndex, boolean isRatisEnabled) {
        if (Boolean.valueOf(keyInfo.getMetadata().get("gdprEnabled")).booleanValue()) {
            keyInfo.getMetadata().remove("gdprEnabled");
            keyInfo.getMetadata().remove("algorithm");
            keyInfo.getMetadata().remove("secret");
            keyInfo.clearFileEncryptionInfo();
        }
        keyInfo.setUpdateID(trxnLogIndex, isRatisEnabled);
        if (repeatedOmKeyInfo == null) {
            repeatedOmKeyInfo = new RepeatedOmKeyInfo(keyInfo);
        } else {
            repeatedOmKeyInfo.addOmKeyInfo(keyInfo);
        }
        return repeatedOmKeyInfo;
    }
}

