/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils.db;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.hdds.StringUtils;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.hdds.utils.db.ByteArrayKeyValue;
import org.apache.hadoop.hdds.utils.db.RDBBatchOperation;
import org.apache.hadoop.hdds.utils.db.RDBMetrics;
import org.apache.hadoop.hdds.utils.db.RDBStoreIterator;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.TableIterator;
import org.apache.hadoop.ozone.shaded.org.rocksdb.ColumnFamilyHandle;
import org.apache.hadoop.ozone.shaded.org.rocksdb.ReadOptions;
import org.apache.hadoop.ozone.shaded.org.rocksdb.RocksDB;
import org.apache.hadoop.ozone.shaded.org.rocksdb.RocksDBException;
import org.apache.hadoop.ozone.shaded.org.rocksdb.WriteOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
class RDBTable
implements Table<byte[], byte[]> {
    private static final Logger LOG = LoggerFactory.getLogger(RDBTable.class);
    private final RocksDB db;
    private final ColumnFamilyHandle handle;
    private final WriteOptions writeOptions;
    private final RDBMetrics rdbMetrics;

    RDBTable(RocksDB db, ColumnFamilyHandle handle, WriteOptions writeOptions, RDBMetrics rdbMetrics) {
        this.db = db;
        this.handle = handle;
        this.writeOptions = writeOptions;
        this.rdbMetrics = rdbMetrics;
    }

    public static IOException toIOException(String msg, RocksDBException e) {
        String statusCode = e.getStatus() == null ? "N/A" : e.getStatus().getCodeString();
        String errMessage = e.getMessage() == null ? "Unknown error" : e.getMessage();
        String output = msg + "; status : " + statusCode + "; message : " + errMessage;
        return new IOException(output, e);
    }

    public ColumnFamilyHandle getHandle() {
        return this.handle;
    }

    @Override
    public void put(byte[] key, byte[] value) throws IOException {
        try {
            this.db.put(this.handle, this.writeOptions, key, value);
        }
        catch (RocksDBException e) {
            LOG.error("Failed to write to DB. Key: {}", (Object)new String(key, StandardCharsets.UTF_8));
            throw RDBTable.toIOException("Failed to put key-value to metadata store", e);
        }
    }

    @Override
    public void putWithBatch(BatchOperation batch, byte[] key, byte[] value) throws IOException {
        if (!(batch instanceof RDBBatchOperation)) {
            throw new IllegalArgumentException("batch should be RDBBatchOperation");
        }
        ((RDBBatchOperation)batch).put(this.getHandle(), key, value);
    }

    @Override
    public boolean isEmpty() throws IOException {
        try (TableIterator<byte[], ByteArrayKeyValue> keyIter = this.iterator();){
            keyIter.seekToFirst();
            boolean bl = !keyIter.hasNext();
            return bl;
        }
    }

    @Override
    public boolean isExist(byte[] key) throws IOException {
        try {
            this.rdbMetrics.incNumDBKeyMayExistChecks();
            StringBuilder outValue = new StringBuilder();
            boolean keyMayExist = this.db.keyMayExist(this.handle, key, outValue);
            if (keyMayExist) {
                boolean keyExists;
                boolean bl = keyExists = outValue.length() > 0 || this.db.get(this.handle, key) != null;
                if (!keyExists) {
                    this.rdbMetrics.incNumDBKeyMayExistMisses();
                }
                return keyExists;
            }
            return false;
        }
        catch (RocksDBException e) {
            throw RDBTable.toIOException("Error in accessing DB. ", e);
        }
    }

    @Override
    public byte[] get(byte[] key) throws IOException {
        try {
            return this.db.get(this.handle, key);
        }
        catch (RocksDBException e) {
            throw RDBTable.toIOException("Failed to get the value for the given key", e);
        }
    }

    @Override
    public byte[] getIfExist(byte[] key) throws IOException {
        try {
            this.rdbMetrics.incNumDBKeyGetIfExistChecks();
            StringBuilder outValue = new StringBuilder();
            boolean keyMayExist = this.db.keyMayExist(this.handle, key, outValue);
            if (keyMayExist) {
                this.rdbMetrics.incNumDBKeyGetIfExistGets();
                byte[] val = this.db.get(this.handle, key);
                if (val == null) {
                    this.rdbMetrics.incNumDBKeyGetIfExistMisses();
                }
                return val;
            }
            return null;
        }
        catch (RocksDBException e) {
            throw RDBTable.toIOException("Error in accessing DB. ", e);
        }
    }

    @Override
    public void delete(byte[] key) throws IOException {
        try {
            this.db.delete(this.handle, key);
        }
        catch (RocksDBException e) {
            throw RDBTable.toIOException("Failed to delete the given key", e);
        }
    }

    @Override
    public void deleteWithBatch(BatchOperation batch, byte[] key) throws IOException {
        if (!(batch instanceof RDBBatchOperation)) {
            throw new IllegalArgumentException("batch should be RDBBatchOperation");
        }
        ((RDBBatchOperation)batch).delete(this.getHandle(), key);
    }

    @Override
    public TableIterator<byte[], ByteArrayKeyValue> iterator() {
        ReadOptions readOptions = new ReadOptions();
        readOptions.setFillCache(false);
        return new RDBStoreIterator(this.db.newIterator(this.handle, readOptions));
    }

    @Override
    public String getName() throws IOException {
        try {
            return StringUtils.bytes2String(this.getHandle().getName());
        }
        catch (RocksDBException rdbEx) {
            throw RDBTable.toIOException("Unable to get the table name.", rdbEx);
        }
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    public long getEstimatedKeyCount() throws IOException {
        try {
            return this.db.getLongProperty(this.handle, "rocksdb.estimate-num-keys");
        }
        catch (RocksDBException e) {
            throw RDBTable.toIOException("Failed to get estimated key count of table " + this.getName(), e);
        }
    }
}

