/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils.db;

import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import org.apache.hadoop.hdds.utils.db.ByteArrayKeyValue;
import org.apache.hadoop.hdds.utils.db.TableIterator;
import org.apache.hadoop.ozone.shaded.org.rocksdb.RocksIterator;

public class RDBStoreIterator
implements TableIterator<byte[], ByteArrayKeyValue> {
    private RocksIterator rocksDBIterator;

    public RDBStoreIterator(RocksIterator iterator) {
        this.rocksDBIterator = iterator;
        this.rocksDBIterator.seekToFirst();
    }

    @Override
    public void forEachRemaining(Consumer<? super ByteArrayKeyValue> action) {
        while (this.hasNext()) {
            action.accept(this.next());
        }
    }

    @Override
    public boolean hasNext() {
        return this.rocksDBIterator.isValid();
    }

    @Override
    public ByteArrayKeyValue next() {
        if (this.rocksDBIterator.isValid()) {
            ByteArrayKeyValue value = ByteArrayKeyValue.create(this.rocksDBIterator.key(), this.rocksDBIterator.value());
            this.rocksDBIterator.next();
            return value;
        }
        throw new NoSuchElementException("RocksDB Store has no more elements");
    }

    @Override
    public void seekToFirst() {
        this.rocksDBIterator.seekToFirst();
    }

    @Override
    public void seekToLast() {
        this.rocksDBIterator.seekToLast();
    }

    @Override
    public ByteArrayKeyValue seek(byte[] key) {
        this.rocksDBIterator.seek(key);
        if (this.rocksDBIterator.isValid()) {
            return ByteArrayKeyValue.create(this.rocksDBIterator.key(), this.rocksDBIterator.value());
        }
        return null;
    }

    @Override
    public byte[] key() {
        if (this.rocksDBIterator.isValid()) {
            return this.rocksDBIterator.key();
        }
        return null;
    }

    @Override
    public ByteArrayKeyValue value() {
        if (this.rocksDBIterator.isValid()) {
            return ByteArrayKeyValue.create(this.rocksDBIterator.key(), this.rocksDBIterator.value());
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        this.rocksDBIterator.close();
    }
}

