/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils.db;

import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.ozone.shaded.com.google.common.annotations.VisibleForTesting;

public class RDBMetrics {
    private static final String SOURCE_NAME = RDBMetrics.class.getSimpleName();
    @Metric
    private MutableCounterLong numDBKeyMayExistChecks;
    @Metric
    private MutableCounterLong numDBKeyMayExistMisses;
    @Metric
    private MutableCounterLong numDBKeyGetIfExistChecks;
    @Metric
    private MutableCounterLong numDBKeyGetIfExistMisses;
    @Metric
    private MutableCounterLong numDBKeyGetIfExistGets;

    public static RDBMetrics create() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        return (RDBMetrics)ms.register(SOURCE_NAME, "Rocks DB Metrics", (Object)new RDBMetrics());
    }

    public long getNumDBKeyGetIfExistGets() {
        return this.numDBKeyGetIfExistGets.value();
    }

    public void incNumDBKeyGetIfExistGets() {
        this.numDBKeyGetIfExistGets.incr();
    }

    public long getNumDBKeyGetIfExistChecks() {
        return this.numDBKeyGetIfExistChecks.value();
    }

    public void incNumDBKeyGetIfExistChecks() {
        this.numDBKeyGetIfExistChecks.incr();
    }

    public long getNumDBKeyGetIfExistMisses() {
        return this.numDBKeyGetIfExistMisses.value();
    }

    public void incNumDBKeyGetIfExistMisses() {
        this.numDBKeyGetIfExistMisses.incr();
    }

    public void incNumDBKeyMayExistChecks() {
        this.numDBKeyMayExistChecks.incr();
    }

    public void incNumDBKeyMayExistMisses() {
        this.numDBKeyMayExistMisses.incr();
    }

    @VisibleForTesting
    public long getNumDBKeyMayExistChecks() {
        return this.numDBKeyMayExistChecks.value();
    }

    @VisibleForTesting
    public long getNumDBKeyMayExistMisses() {
        return this.numDBKeyMayExistMisses.value();
    }

    public void unRegister() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        ms.unregisterSource(SOURCE_NAME);
    }
}

