/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils.db;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.Instant;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hdds.utils.db.RocksDBCheckpoint;
import org.apache.hadoop.ozone.shaded.org.rocksdb.Checkpoint;
import org.apache.hadoop.ozone.shaded.org.rocksdb.RocksDB;
import org.apache.hadoop.ozone.shaded.org.rocksdb.RocksDBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDBCheckpointManager {
    private final Checkpoint checkpoint;
    private final RocksDB db;
    public static final String RDB_CHECKPOINT_DIR_PREFIX = "rdb_checkpoint_";
    private static final Logger LOG = LoggerFactory.getLogger(RDBCheckpointManager.class);
    private String checkpointNamePrefix = "";

    public RDBCheckpointManager(RocksDB rocksDB) {
        this.db = rocksDB;
        this.checkpoint = Checkpoint.create(rocksDB);
    }

    public RDBCheckpointManager(RocksDB rocksDB, String checkpointPrefix) {
        this.db = rocksDB;
        this.checkpointNamePrefix = checkpointPrefix;
        this.checkpoint = Checkpoint.create(rocksDB);
    }

    public RocksDBCheckpoint createCheckpoint(String parentDir) {
        try {
            long currentTime = System.currentTimeMillis();
            String checkpointDir = "";
            if (StringUtils.isNotEmpty((CharSequence)this.checkpointNamePrefix)) {
                checkpointDir = checkpointDir + this.checkpointNamePrefix;
            }
            checkpointDir = checkpointDir + "_rdb_checkpoint_" + currentTime;
            Path checkpointPath = Paths.get(parentDir, checkpointDir);
            Instant start = Instant.now();
            this.checkpoint.createCheckpoint(checkpointPath.toString());
            Instant end = Instant.now();
            long duration = Duration.between(start, end).toMillis();
            LOG.info("Created checkpoint at {} in {} milliseconds", (Object)checkpointPath.toString(), (Object)duration);
            return new RocksDBCheckpoint(checkpointPath, currentTime, this.db.getLatestSequenceNumber(), duration);
        }
        catch (RocksDBException e) {
            LOG.error("Unable to create RocksDB Snapshot.", (Throwable)e);
            return null;
        }
    }
}

