/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils.db;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.apache.hadoop.hdds.utils.db.RDBTable;
import org.apache.hadoop.ozone.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.ozone.shaded.org.rocksdb.ColumnFamilyDescriptor;
import org.apache.hadoop.ozone.shaded.org.rocksdb.DBOptions;
import org.apache.hadoop.ozone.shaded.org.rocksdb.Env;
import org.apache.hadoop.ozone.shaded.org.rocksdb.OptionsUtil;
import org.apache.hadoop.ozone.shaded.org.rocksdb.RocksDBException;
import org.eclipse.jetty.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DBConfigFromFile {
    private static final Logger LOG = LoggerFactory.getLogger(DBConfigFromFile.class);
    public static final String CONFIG_DIR = "HADOOP_CONF_DIR";

    private DBConfigFromFile() {
    }

    public static File getConfigLocation() throws IOException {
        String path = System.getenv(CONFIG_DIR);
        if (StringUtil.isBlank((String)path)) {
            path = System.getProperty(CONFIG_DIR);
        }
        if (StringUtil.isBlank((String)path)) {
            LOG.debug("Unable to find the configuration directory. Please make sure that HADOOP_CONF_DIR is setup correctly.");
        }
        if (StringUtil.isBlank((String)path)) {
            return null;
        }
        return new File(path);
    }

    public static String getOptionsFileNameFromDB(String dbFileName) {
        Preconditions.checkNotNull(dbFileName);
        return dbFileName + ".ini";
    }

    public static DBOptions readFromFile(String dbFileName, List<ColumnFamilyDescriptor> cfDescs) throws IOException {
        Path optionsFile;
        Preconditions.checkNotNull(dbFileName);
        Preconditions.checkNotNull(cfDescs);
        Preconditions.checkArgument(cfDescs.size() > 0);
        Env env = Env.getDefault();
        DBOptions options = null;
        File configLocation = DBConfigFromFile.getConfigLocation();
        if (configLocation != null && StringUtil.isNotBlank((String)configLocation.toString()) && (optionsFile = Paths.get(configLocation.toString(), DBConfigFromFile.getOptionsFileNameFromDB(dbFileName))).toFile().exists()) {
            options = new DBOptions();
            try {
                OptionsUtil.loadOptionsFromFile(optionsFile.toString(), env, options, cfDescs, true);
            }
            catch (RocksDBException rdEx) {
                RDBTable.toIOException("Unable to find/open Options file.", rdEx);
            }
        }
        return options;
    }
}

