/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils.db;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hdds.utils.db.ByteArrayCodec;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.hdds.utils.db.LongCodec;
import org.apache.hadoop.hdds.utils.db.StringCodec;
import org.apache.hadoop.ozone.shaded.com.google.common.base.Preconditions;

public class CodecRegistry {
    private Map<Class, Codec<?>> valueCodecs = new HashMap();

    public CodecRegistry() {
        this.valueCodecs.put(String.class, new StringCodec());
        this.valueCodecs.put(Long.class, new LongCodec());
        this.valueCodecs.put(byte[].class, new ByteArrayCodec());
    }

    public <T> T asObject(byte[] rawData, Class<T> format) throws IOException {
        if (rawData == null) {
            return null;
        }
        Codec codec = this.getCodec(format);
        return codec.fromPersistedFormat(rawData);
    }

    public <T> T copyObject(T object, Class<T> format) throws IOException {
        if (object == null) {
            return null;
        }
        Codec codec = this.getCodec(format);
        return codec.copyObject(object);
    }

    public <T> byte[] asRawData(T object) throws IOException {
        Preconditions.checkNotNull(object, "Null value shouldn't be persisted in the database");
        Codec codec = this.getCodec(object);
        return codec.toPersistedFormat(object);
    }

    private <T> Codec getCodec(T object) throws IOException {
        Class<?> format = object.getClass();
        return this.getCodec(format);
    }

    private <T> Codec getCodec(Class<T> format) throws IOException {
        Codec<?> codec;
        if (this.valueCodecs.containsKey(format)) {
            codec = this.valueCodecs.get(format);
        } else if (this.valueCodecs.containsKey(format.getSuperclass())) {
            codec = this.valueCodecs.get(format.getSuperclass());
        } else {
            throw new IllegalStateException("Codec is not registered for type: " + format);
        }
        return codec;
    }

    public <T> void addCodec(Class<T> type, Codec<T> codec) {
        this.valueCodecs.put(type, codec);
    }
}

