/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils;

import org.apache.hadoop.hdds.utils.ResourceSemaphore;
import org.junit.Assert;
import org.junit.Test;

public class TestResourceSemaphore {
    @Test(timeout=1000L)
    public void testGroup() {
        ResourceSemaphore.Group g2 = new ResourceSemaphore.Group(3, 1);
        TestResourceSemaphore.assertUsed(g2, 0, 0);
        TestResourceSemaphore.assertAcquire(g2, true, 1, 1);
        TestResourceSemaphore.assertUsed(g2, 1, 1);
        TestResourceSemaphore.assertAcquire(g2, false, 1, 1);
        TestResourceSemaphore.assertUsed(g2, 1, 1);
        TestResourceSemaphore.assertAcquire(g2, false, 0, 1);
        TestResourceSemaphore.assertUsed(g2, 1, 1);
        TestResourceSemaphore.assertAcquire(g2, true, 1, 0);
        TestResourceSemaphore.assertUsed(g2, 2, 1);
        TestResourceSemaphore.assertAcquire(g2, true, 1, 0);
        TestResourceSemaphore.assertUsed(g2, 3, 1);
        TestResourceSemaphore.assertAcquire(g2, false, 1, 0);
        TestResourceSemaphore.assertUsed(g2, 3, 1);
        g2.release(1, 1);
        TestResourceSemaphore.assertUsed(g2, 2, 0);
        g2.release(2, 0);
        TestResourceSemaphore.assertUsed(g2, 0, 0);
        g2.release(0, 0);
        TestResourceSemaphore.assertUsed(g2, 0, 0);
        try {
            g2.release(1, 0);
            Assert.fail((String)"Should have failed.");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            g2.release(0, 1);
            Assert.fail((String)"Should have failed.");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    static void assertUsed(ResourceSemaphore.Group g2, int ... expected) {
        Assert.assertEquals((long)expected.length, (long)g2.resourceSize());
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((long)expected[i], (long)g2.get(i).used());
        }
    }

    static void assertAcquire(ResourceSemaphore.Group g2, boolean expected, int ... permits) {
        boolean computed = g2.tryAcquire(permits);
        Assert.assertEquals((Object)expected, (Object)computed);
    }
}

