/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.hdds.utils.ResourceLimitCache;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestResourceLimitCache {
    @Test
    public void testResourceLimitCache() throws InterruptedException, TimeoutException {
        ResourceLimitCache<Integer, String> resourceCache = new ResourceLimitCache<Integer, String>(new ConcurrentHashMap(), (k, v) -> new int[]{k}, 10);
        resourceCache.put(6, "a");
        resourceCache.put(4, "a");
        resourceCache.put(4, "a");
        CompletableFuture<String> future = CompletableFuture.supplyAsync(() -> {
            try {
                return resourceCache.put(1, "a");
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return null;
            }
        });
        Assert.assertTrue((!future.isDone() ? 1 : 0) != 0);
        Thread.sleep(100L);
        Assert.assertTrue((!future.isDone() ? 1 : 0) != 0);
        resourceCache.remove(4);
        GenericTestUtils.waitFor(future::isDone, (int)100, (int)1000);
        Assert.assertTrue((future.isDone() && !future.isCompletedExceptionally() ? 1 : 0) != 0);
        Assert.assertNotNull(resourceCache.get(1));
        future = CompletableFuture.supplyAsync(() -> {
            try {
                return resourceCache.put(4, "a");
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return null;
            }
        });
        Assert.assertTrue((!future.isDone() ? 1 : 0) != 0);
        Thread.sleep(100L);
        Assert.assertTrue((!future.isDone() ? 1 : 0) != 0);
        future.cancel(true);
        resourceCache.remove(1);
        Assert.assertNull(resourceCache.get(4));
    }
}

