/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils;

import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.apache.hadoop.hdds.utils.Cache;
import org.apache.hadoop.hdds.utils.ResourceSemaphore;

public class ResourceLimitCache<K, V>
implements Cache<K, V> {
    private final ConcurrentMap<K, V> map;
    private final ResourceSemaphore.Group group;
    private final BiFunction<K, V, int[]> permitsSupplier;

    public ResourceLimitCache(ConcurrentMap<K, V> map, BiFunction<K, V, int[]> permitsSupplier, int ... limits) {
        Objects.requireNonNull(map);
        Objects.requireNonNull(permitsSupplier);
        Objects.requireNonNull(limits);
        this.map = map;
        this.group = new ResourceSemaphore.Group(limits);
        this.permitsSupplier = permitsSupplier;
    }

    @Override
    public V get(K key) {
        Objects.requireNonNull(key);
        return this.map.get(key);
    }

    @Override
    public V put(K key, V value) throws InterruptedException {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        V oldVal = this.remove(key);
        int[] permits = this.permitsSupplier.apply(key, value);
        this.group.acquire(permits);
        try {
            this.map.put(key, value);
        }
        catch (Throwable t) {
            this.group.release(permits);
        }
        return oldVal;
    }

    @Override
    public V remove(K key) {
        Objects.requireNonNull(key);
        Object val = this.map.remove(key);
        if (val != null) {
            this.group.release(this.permitsSupplier.apply(key, val));
        }
        return val;
    }

    @Override
    public void removeIf(Predicate<K> predicate) {
        Objects.requireNonNull(predicate);
        this.map.keySet().removeIf(predicate);
    }

    @Override
    public void clear() {
        for (Object key : this.map.keySet()) {
            this.remove(key);
        }
    }
}

