/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.WritableByteChannel;
import org.apache.hadoop.ozone.shaded.com.google.common.base.Preconditions;

public class MockGatheringChannel
implements GatheringByteChannel {
    private final WritableByteChannel delegate;

    public MockGatheringChannel(WritableByteChannel delegate) {
        this.delegate = delegate;
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        Preconditions.checkElementIndex(offset, srcs.length, "offset");
        Preconditions.checkElementIndex(offset + length - 1, srcs.length, "offset+length");
        long bytes = 0L;
        for (ByteBuffer b : srcs) {
            bytes += (long)this.write(b);
        }
        return bytes;
    }

    @Override
    public long write(ByteBuffer[] srcs) throws IOException {
        return this.write(srcs, 0, srcs.length);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        return this.delegate.write(src);
    }

    @Override
    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }
}

