/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hdds.StringUtils;
import org.apache.hadoop.ozone.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.ozone.shaded.com.google.common.base.Strings;

public final class MetadataKeyFilters {
    private static KeyPrefixFilter deletingKeyFilter = new KeyPrefixFilter().addFilter("#deleting#");
    private static KeyPrefixFilter deletedKeyFilter = new KeyPrefixFilter().addFilter("#deleted#");
    private static KeyPrefixFilter normalKeyFilter = new KeyPrefixFilter().addFilter("#deleting#", true).addFilter("#deleted#", true).addFilter("#delTX#", true).addFilter("#BCSID", true);

    private MetadataKeyFilters() {
    }

    public static KeyPrefixFilter getDeletingKeyFilter() {
        return deletingKeyFilter;
    }

    public static KeyPrefixFilter getDeletedKeyFilter() {
        return deletedKeyFilter;
    }

    public static KeyPrefixFilter getNormalKeyFilter() {
        return normalKeyFilter;
    }

    public static class KeyPrefixFilter
    implements MetadataKeyFilter {
        private List<String> positivePrefixList = new ArrayList<String>();
        private List<String> negativePrefixList = new ArrayList<String>();
        private boolean atleastOnePositiveMatch;
        private int keysScanned = 0;
        private int keysHinted = 0;

        public KeyPrefixFilter() {
        }

        public KeyPrefixFilter(boolean atleastOnePositiveMatch) {
            this.atleastOnePositiveMatch = atleastOnePositiveMatch;
        }

        public KeyPrefixFilter addFilter(String keyPrefix) {
            this.addFilter(keyPrefix, false);
            return this;
        }

        public KeyPrefixFilter addFilter(String keyPrefix, boolean negative) {
            Preconditions.checkArgument(!Strings.isNullOrEmpty(keyPrefix), "KeyPrefix is null or empty: " + keyPrefix);
            if (negative) {
                Preconditions.checkArgument(this.positivePrefixList.stream().noneMatch(prefix -> prefix.startsWith(keyPrefix) || keyPrefix.startsWith((String)prefix)), "KeyPrefix: " + keyPrefix + " already accepted.");
                this.negativePrefixList.add(keyPrefix);
            } else {
                Preconditions.checkArgument(this.negativePrefixList.stream().noneMatch(prefix -> prefix.startsWith(keyPrefix) || keyPrefix.startsWith((String)prefix)), "KeyPrefix: " + keyPrefix + " already rejected.");
                this.positivePrefixList.add(keyPrefix);
            }
            return this;
        }

        @Override
        public boolean filterKey(byte[] preKey, byte[] currentKey, byte[] nextKey) {
            boolean accept;
            ++this.keysScanned;
            if (currentKey == null) {
                return false;
            }
            if (this.positivePrefixList.isEmpty() && this.negativePrefixList.isEmpty()) {
                return true;
            }
            boolean bl = accept = !this.positivePrefixList.isEmpty() && this.positivePrefixList.stream().anyMatch(prefix -> {
                byte[] prefixBytes = StringUtils.string2Bytes(prefix);
                return KeyPrefixFilter.prefixMatch(prefixBytes, currentKey);
            });
            if (accept) {
                ++this.keysHinted;
                return true;
            }
            if (this.atleastOnePositiveMatch) {
                return false;
            }
            boolean bl2 = accept = !this.negativePrefixList.isEmpty() && this.negativePrefixList.stream().allMatch(prefix -> {
                byte[] prefixBytes = StringUtils.string2Bytes(prefix);
                return !KeyPrefixFilter.prefixMatch(prefixBytes, currentKey);
            });
            if (accept) {
                ++this.keysHinted;
                return true;
            }
            return false;
        }

        @Override
        public int getKeysScannedNum() {
            return this.keysScanned;
        }

        @Override
        public int getKeysHintedNum() {
            return this.keysHinted;
        }

        private static boolean prefixMatch(byte[] prefix, byte[] key) {
            Preconditions.checkNotNull(prefix);
            Preconditions.checkNotNull(key);
            if (key.length < prefix.length) {
                return false;
            }
            for (int i = 0; i < prefix.length; ++i) {
                if (key[i] == prefix[i]) continue;
                return false;
            }
            return true;
        }
    }

    public static interface MetadataKeyFilter {
        public boolean filterKey(byte[] var1, byte[] var2, byte[] var3);

        default public int getKeysScannedNum() {
            return 0;
        }

        default public int getKeysHintedNum() {
            return 0;
        }
    }
}

