/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils;

import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.hdds.utils.BackgroundTask;
import org.apache.hadoop.hdds.utils.BackgroundTaskQueue;
import org.apache.hadoop.hdds.utils.BackgroundTaskResult;
import org.apache.hadoop.ozone.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.ozone.shaded.com.google.common.collect.Lists;
import org.apache.hadoop.ozone.shaded.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BackgroundService {
    @VisibleForTesting
    public static final Logger LOG = LoggerFactory.getLogger(BackgroundService.class);
    private final ScheduledExecutorService exec;
    private final ThreadGroup threadGroup;
    private final ThreadFactory threadFactory;
    private final String serviceName;
    private final long interval;
    private final long serviceTimeout;
    private final TimeUnit unit;
    private final PeriodicalTask service;

    public BackgroundService(String serviceName, long interval, TimeUnit unit, int threadPoolSize, long serviceTimeout) {
        this.interval = interval;
        this.unit = unit;
        this.serviceName = serviceName;
        this.serviceTimeout = serviceTimeout;
        this.threadGroup = new ThreadGroup(serviceName);
        ThreadFactory tf = r -> new Thread(this.threadGroup, r);
        this.threadFactory = new ThreadFactoryBuilder().setThreadFactory(tf).setDaemon(true).setNameFormat(serviceName + "#%d").build();
        this.exec = Executors.newScheduledThreadPool(threadPoolSize, this.threadFactory);
        this.service = new PeriodicalTask();
    }

    protected ExecutorService getExecutorService() {
        return this.exec;
    }

    @VisibleForTesting
    public int getThreadCount() {
        return this.threadGroup.activeCount();
    }

    @VisibleForTesting
    public void triggerBackgroundTaskForTesting() {
        this.service.run();
    }

    public void start() {
        this.exec.scheduleWithFixedDelay(this.service, 0L, this.interval, this.unit);
    }

    public abstract BackgroundTaskQueue getTasks();

    public void shutdown() {
        LOG.info("Shutting down service {}", (Object)this.serviceName);
        this.exec.shutdown();
        try {
            if (!this.exec.awaitTermination(60L, TimeUnit.SECONDS)) {
                this.exec.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.exec.shutdownNow();
        }
        if (this.threadGroup.activeCount() == 0 && !this.threadGroup.isDestroyed()) {
            this.threadGroup.destroy();
        }
    }

    public class PeriodicalTask
    implements Runnable {
        @Override
        public synchronized void run() {
            BackgroundTaskQueue tasks;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Running background service : {}", (Object)BackgroundService.this.serviceName);
            }
            if ((tasks = BackgroundService.this.getTasks()).isEmpty()) {
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Number of background tasks to execute : {}", (Object)tasks.size());
            }
            ExecutorCompletionService taskCompletionService = new ExecutorCompletionService(BackgroundService.this.exec);
            ArrayList results = Lists.newArrayList();
            while (tasks.size() > 0) {
                BackgroundTask task = tasks.poll();
                Future result = taskCompletionService.submit(task);
                results.add(result);
            }
            results.parallelStream().forEach(taskResultFuture -> {
                try {
                    BackgroundTaskResult result;
                    BackgroundTaskResult backgroundTaskResult = result = BackgroundService.this.serviceTimeout > 0L ? (BackgroundTaskResult)taskResultFuture.get(BackgroundService.this.serviceTimeout, BackgroundService.this.unit) : (BackgroundTaskResult)taskResultFuture.get();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("task execution result size {}", (Object)result.getSize());
                    }
                }
                catch (InterruptedException e) {
                    LOG.warn("Background task failed due to interruption, retrying in next interval", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException e) {
                    LOG.warn("Background task fails to execute, retrying in next interval", (Throwable)e);
                }
                catch (TimeoutException e) {
                    LOG.warn("Background task executes timed out, retrying in next interval", (Throwable)e);
                }
            });
        }
    }
}

