/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.tracing;

import java.lang.reflect.Proxy;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.tracing.StringCodec;
import org.apache.hadoop.hdds.tracing.TraceAllMethod;
import org.apache.hadoop.ozone.shaded.io.jaegertracing.internal.JaegerTracer;
import org.apache.hadoop.ozone.shaded.io.opentracing.Scope;
import org.apache.hadoop.ozone.shaded.io.opentracing.Span;
import org.apache.hadoop.ozone.shaded.io.opentracing.SpanContext;
import org.apache.hadoop.ozone.shaded.io.opentracing.Tracer;
import org.apache.hadoop.ozone.shaded.io.opentracing.util.GlobalTracer;

public final class TracingUtil {
    private static final String NULL_SPAN_AS_STRING = "";

    private TracingUtil() {
    }

    public static void initTracing(String serviceName, Configuration conf) {
        if (!GlobalTracer.isRegistered() && TracingUtil.isTracingEnabled(conf)) {
            org.apache.hadoop.ozone.shaded.io.jaegertracing.Configuration config = org.apache.hadoop.ozone.shaded.io.jaegertracing.Configuration.fromEnv(serviceName);
            JaegerTracer tracer = config.getTracerBuilder().registerExtractor(StringCodec.FORMAT, new StringCodec()).registerInjector(StringCodec.FORMAT, new StringCodec()).build();
            GlobalTracer.register(tracer);
        }
    }

    public static String exportCurrentSpan() {
        return TracingUtil.exportSpan(GlobalTracer.get().activeSpan());
    }

    public static String exportSpan(Span span) {
        if (span != null) {
            StringBuilder builder = new StringBuilder();
            GlobalTracer.get().inject(span.context(), StringCodec.FORMAT, builder);
            return builder.toString();
        }
        return NULL_SPAN_AS_STRING;
    }

    public static Scope importAndCreateScope(String name, String encodedParent) {
        Tracer tracer = GlobalTracer.get();
        return tracer.buildSpan(name).asChildOf(TracingUtil.extractParent(encodedParent, tracer)).startActive(true);
    }

    private static SpanContext extractParent(String parent, Tracer tracer) {
        if (!GlobalTracer.isRegistered()) {
            return null;
        }
        if (parent == null || parent.isEmpty()) {
            return null;
        }
        return tracer.extract(StringCodec.FORMAT, new StringBuilder(parent));
    }

    public static <T> T createProxy(T delegate, Class<T> itf, Configuration conf) {
        if (!TracingUtil.isTracingEnabled(conf)) {
            return delegate;
        }
        Class<?> aClass = delegate.getClass();
        return itf.cast(Proxy.newProxyInstance(aClass.getClassLoader(), new Class[]{itf}, new TraceAllMethod<T>(delegate, itf.getSimpleName())));
    }

    private static boolean isTracingEnabled(Configuration conf) {
        return conf.getBoolean("hdds.tracing.enabled", true);
    }
}

