/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.tracing;

import org.apache.hadoop.hdds.tracing.StringCodec;
import org.apache.hadoop.ozone.shaded.io.jaegertracing.internal.JaegerSpanContext;
import org.apache.hadoop.ozone.shaded.io.jaegertracing.internal.exceptions.EmptyTracerStateStringException;
import org.apache.hadoop.ozone.shaded.io.jaegertracing.internal.exceptions.MalformedTracerStateStringException;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestStringCodec {
    TestStringCodec() {
    }

    @Test
    void testExtract() throws Exception {
        StringCodec codec = new StringCodec();
        LambdaTestUtils.intercept(EmptyTracerStateStringException.class, () -> codec.extract(null));
        StringBuilder sb = new StringBuilder().append("123");
        LambdaTestUtils.intercept(MalformedTracerStateStringException.class, (String)"String does not match tracer state format", () -> codec.extract(sb));
        sb.append(":456:789");
        LambdaTestUtils.intercept(MalformedTracerStateStringException.class, (String)"String does not match tracer state format", () -> codec.extract(sb));
        sb.append(":66");
        JaegerSpanContext context = codec.extract(sb);
        String expectedContextString = new String("123:456:789:66");
        Assertions.assertTrue((boolean)context.getTraceId().equals("123"));
        Assertions.assertTrue((boolean)context.toString().equals(expectedContextString));
    }
}

