/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.server.http;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.ozone.shaded.io.prometheus.client.Collector;
import org.apache.hadoop.ozone.shaded.io.prometheus.client.dropwizard.samplebuilder.DefaultSampleBuilder;
import org.apache.logging.log4j.util.Strings;

public class RatisNameRewriteSampleBuilder
extends DefaultSampleBuilder {
    private List<Pattern> followerPatterns = new ArrayList<Pattern>();

    public RatisNameRewriteSampleBuilder() {
        this.followerPatterns.add(Pattern.compile("grpc_log_appender_follower_(.*)_(latency|success|inconsistency).*"));
        this.followerPatterns.add(Pattern.compile("follower_(.*)_lastHeartbeatElapsedTime"));
        this.followerPatterns.add(Pattern.compile("(.*)_peerCommitIndex"));
    }

    @Override
    public Collector.MetricFamilySamples.Sample createSample(String dropwizardName, String nameSuffix, List<String> additionalLabelNames, List<String> additionalLabelValues, double value) {
        if (dropwizardName.startsWith("ratis") || dropwizardName.startsWith("ratis_grpc")) {
            ArrayList<String> names = new ArrayList<String>(additionalLabelNames);
            ArrayList<String> values = new ArrayList<String>(additionalLabelValues);
            String name = this.normalizeRatisMetric(dropwizardName, names, values);
            return super.createSample(name, nameSuffix, names, values, value);
        }
        return super.createSample(dropwizardName, nameSuffix, additionalLabelNames, additionalLabelValues, value);
    }

    protected String normalizeRatisMetric(String dropwizardName, List<String> names, List<String> values) {
        ArrayList<String> nameParts = new ArrayList<String>(Arrays.asList(dropwizardName.split("\\.")));
        if (nameParts.size() > 2) {
            String[] identifiers = ((String)nameParts.get(2)).split("@");
            names.add("instance");
            values.add(identifiers[0]);
            if (identifiers.length > 1) {
                names.add("group");
                values.add(identifiers[1]);
            }
            nameParts.remove(2);
        }
        if (nameParts.size() > 2) {
            for (Pattern pattern : this.followerPatterns) {
                Matcher matcher = pattern.matcher((CharSequence)nameParts.get(2));
                if (!matcher.matches()) continue;
                names.add("follower");
                String followerId = matcher.group(1);
                values.add(followerId);
                nameParts.set(2, ((String)nameParts.get(2)).replace(followerId + "_", ""));
            }
        }
        return Strings.join(nameParts, (char)'.');
    }
}

