/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.server.http;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.ozone.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.ozone.shaded.com.google.common.base.Joiner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(ProfileServlet.class);
    private static final String ACCESS_CONTROL_ALLOW_METHODS = "Access-Control-Allow-Methods";
    private static final String ALLOWED_METHODS = "GET";
    private static final String ACCESS_CONTROL_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
    private static final String CONTENT_TYPE_TEXT = "text/plain; charset=utf-8";
    private static final String ASYNC_PROFILER_HOME_ENV = "ASYNC_PROFILER_HOME";
    private static final String ASYNC_PROFILER_HOME_SYSTEM_PROPERTY = "async.profiler.home";
    private static final String PROFILER_SCRIPT = "/profiler.sh";
    private static final int DEFAULT_DURATION_SECONDS = 10;
    private static final AtomicInteger ID_GEN = new AtomicInteger(0);
    static final Path OUTPUT_DIR = Paths.get(System.getProperty("java.io.tmpdir"), "prof-output");
    public static final String FILE_PREFIX = "async-prof-pid-";
    public static final Pattern FILE_NAME_PATTERN = Pattern.compile("async-prof-pid-[0-9]+-[0-9A-Za-z\\-_]+-[0-9]+\\.[a-z]+");
    private Lock profilerLock = new ReentrantLock();
    private final Integer pid;
    private String asyncProfilerHome = ProfileServlet.getAsyncProfilerHome();
    private transient Process process;

    public ProfileServlet() {
        this.pid = this.getPid();
        LOG.info("Servlet process PID: {} asyncProfilerHome: {}", (Object)this.pid, (Object)this.asyncProfilerHome);
        try {
            Files.createDirectories(OUTPUT_DIR, new FileAttribute[0]);
        }
        catch (IOException e) {
            LOG.error("Can't create the output directory for java profiler: " + OUTPUT_DIR, (Throwable)e);
        }
    }

    private Integer getPid() {
        int idx;
        String name;
        String pidStr = System.getenv("JVM_PID");
        if ((pidStr == null || pidStr.trim().isEmpty()) && (name = ManagementFactory.getRuntimeMXBean().getName()) != null && (idx = name.indexOf("@")) != -1) {
            pidStr = name.substring(0, name.indexOf("@"));
        }
        try {
            if (pidStr != null) {
                return Integer.valueOf(pidStr);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    public Process runCmdAsync(List<String> cmd) {
        try {
            LOG.info("Running command async: {}", cmd);
            return new ProcessBuilder(cmd).inheritIO().start();
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @VisibleForTesting
    protected static String generateFileName(Integer pid, Output output, Event event) {
        return FILE_PREFIX + pid + "-" + event.name().toLowerCase() + "-" + ID_GEN.incrementAndGet() + "." + output.name().toLowerCase();
    }

    @VisibleForTesting
    protected static String validateFileName(String filename) {
        if (!FILE_NAME_PATTERN.matcher(filename).matches()) {
            throw new IllegalArgumentException("Invalid file name parameter " + filename + " doesn't match pattern " + FILE_NAME_PATTERN);
        }
        return filename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        block20: {
            if (this.asyncProfilerHome == null || this.asyncProfilerHome.trim().isEmpty()) {
                resp.setStatus(500);
                this.setResponseHeader(resp);
                resp.getWriter().write("ASYNC_PROFILER_HOME env is not set.");
                return;
            }
            if (req.getParameter("file") != null) {
                this.doGetDownload(req.getParameter("file"), req, resp);
                return;
            }
            Integer processId = this.getInteger(req, "pid", this.pid);
            if (processId == null) {
                resp.setStatus(500);
                this.setResponseHeader(resp);
                resp.getWriter().write("'pid' query parameter unspecified or unable to determine PID of current process.");
                return;
            }
            int duration = this.getInteger(req, "duration", 10);
            Output output = this.getOutput(req);
            Event event = this.getEvent(req);
            Long interval = this.getLong(req, "interval");
            Integer jstackDepth = this.getInteger(req, "jstackdepth", null);
            Long bufsize = this.getLong(req, "bufsize");
            boolean thread = req.getParameterMap().containsKey("thread");
            boolean simple = req.getParameterMap().containsKey("simple");
            Integer width = this.getInteger(req, "width", null);
            Integer height = this.getInteger(req, "height", null);
            Double minwidth = this.getMinWidth(req);
            boolean reverse = req.getParameterMap().containsKey("reverse");
            if (this.process == null || !this.process.isAlive()) {
                try {
                    int lockTimeoutSecs = 3;
                    if (this.profilerLock.tryLock(lockTimeoutSecs, TimeUnit.SECONDS)) {
                        try {
                            File outputFile = OUTPUT_DIR.resolve(ProfileServlet.generateFileName(processId, output, event)).toFile();
                            ArrayList<String> cmd = new ArrayList<String>();
                            cmd.add(this.asyncProfilerHome + PROFILER_SCRIPT);
                            cmd.add("-e");
                            cmd.add(event.getInternalName());
                            cmd.add("-d");
                            cmd.add("" + duration);
                            cmd.add("-o");
                            cmd.add(output.name().toLowerCase());
                            cmd.add("-f");
                            cmd.add(outputFile.getAbsolutePath());
                            if (interval != null) {
                                cmd.add("-i");
                                cmd.add(interval.toString());
                            }
                            if (jstackDepth != null) {
                                cmd.add("-j");
                                cmd.add(jstackDepth.toString());
                            }
                            if (bufsize != null) {
                                cmd.add("-b");
                                cmd.add(bufsize.toString());
                            }
                            if (thread) {
                                cmd.add("-t");
                            }
                            if (simple) {
                                cmd.add("-s");
                            }
                            if (width != null) {
                                cmd.add("--width");
                                cmd.add(width.toString());
                            }
                            if (height != null) {
                                cmd.add("--height");
                                cmd.add(height.toString());
                            }
                            if (minwidth != null) {
                                cmd.add("--minwidth");
                                cmd.add(minwidth.toString());
                            }
                            if (reverse) {
                                cmd.add("--reverse");
                            }
                            cmd.add(processId.toString());
                            this.process = this.runCmdAsync(cmd);
                            this.setResponseHeader(resp);
                            resp.setStatus(202);
                            String relativeUrl = "/prof?file=" + outputFile.getName();
                            resp.getWriter().write("Started [" + event.getInternalName() + "] profiling. This page will automatically redirect to " + relativeUrl + " after " + duration + " seconds.\n\ncommand:\n" + Joiner.on(" ").join(cmd));
                            resp.getWriter().write("\n\n\nPlease make sure that you enabled the profiling on kernel level:\necho 1 > /proc/sys/kernel/perf_event_paranoid\necho 0 > /proc/sys/kernel/kptr_restrict\n\nSee https://github.com/jvm-profiling-tools/async-profiler#basic-usage for more details.");
                            int refreshDelay = this.getInteger(req, "refreshDelay", 0);
                            resp.setHeader("Refresh", duration + refreshDelay + ";" + relativeUrl);
                            resp.getWriter().flush();
                            break block20;
                        }
                        finally {
                            this.profilerLock.unlock();
                        }
                    }
                    this.setResponseHeader(resp);
                    resp.setStatus(500);
                    resp.getWriter().write("Unable to acquire lock. Another instance of profiler might be running.");
                    LOG.warn("Unable to acquire lock in {} seconds. Another instance of profiler might be running.", (Object)lockTimeoutSecs);
                }
                catch (InterruptedException e) {
                    LOG.warn("Interrupted while acquiring profile lock.", (Throwable)e);
                    resp.setStatus(500);
                    Thread.currentThread().interrupt();
                }
            } else {
                this.setResponseHeader(resp);
                resp.setStatus(500);
                resp.getWriter().write("Another instance of profiler is already running.");
            }
        }
    }

    protected void doGetDownload(String fileName, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String safeFileName = ProfileServlet.validateFileName(fileName);
        File requestedFile = OUTPUT_DIR.resolve(safeFileName).toAbsolutePath().toFile();
        if (requestedFile.length() < 100L) {
            LOG.info("{} is incomplete. Sending auto-refresh header..", (Object)requestedFile);
            resp.setHeader("Refresh", "2," + req.getRequestURI() + "?file=" + safeFileName);
            resp.getWriter().write("This page will auto-refresh every 2 second until output file is ready..");
        } else {
            if (safeFileName.endsWith(".svg")) {
                resp.setContentType("image/svg+xml");
            } else if (safeFileName.endsWith(".tree")) {
                resp.setContentType("text/html");
            }
            try (FileInputStream input = new FileInputStream(requestedFile);){
                IOUtils.copy((InputStream)input, (OutputStream)resp.getOutputStream());
            }
        }
    }

    private Integer getInteger(HttpServletRequest req, String param, Integer defaultValue) {
        String value = req.getParameter(param);
        if (value != null) {
            try {
                return Integer.valueOf(value);
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    private Long getLong(HttpServletRequest req, String param) {
        String value = req.getParameter(param);
        if (value != null) {
            try {
                return Long.valueOf(value);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    private Double getMinWidth(HttpServletRequest req) {
        String value = req.getParameter("minwidth");
        if (value != null) {
            try {
                return Double.valueOf(value);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    private Event getEvent(HttpServletRequest req) {
        String eventArg = req.getParameter("event");
        if (eventArg != null) {
            Event event = Event.fromInternalName(eventArg);
            return event == null ? Event.CPU : event;
        }
        return Event.CPU;
    }

    private Output getOutput(HttpServletRequest req) {
        String outputArg = req.getParameter("output");
        if (req.getParameter("output") != null) {
            try {
                return Output.valueOf(outputArg.trim().toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return Output.SVG;
            }
        }
        return Output.SVG;
    }

    private void setResponseHeader(HttpServletResponse response) {
        response.setHeader(ACCESS_CONTROL_ALLOW_METHODS, ALLOWED_METHODS);
        response.setHeader(ACCESS_CONTROL_ALLOW_ORIGIN, "*");
        response.setContentType(CONTENT_TYPE_TEXT);
    }

    static String getAsyncProfilerHome() {
        String asyncProfilerHome = System.getenv(ASYNC_PROFILER_HOME_ENV);
        if (asyncProfilerHome == null || asyncProfilerHome.trim().isEmpty()) {
            asyncProfilerHome = System.getProperty(ASYNC_PROFILER_HOME_SYSTEM_PROPERTY);
        }
        return asyncProfilerHome;
    }

    static enum Output {
        SUMMARY,
        TRACES,
        FLAT,
        COLLAPSED,
        SVG,
        TREE,
        JFR;

    }

    static enum Event {
        CPU("cpu"),
        ALLOC("alloc"),
        LOCK("lock"),
        PAGE_FAULTS("page-faults"),
        CONTEXT_SWITCHES("context-switches"),
        CYCLES("cycles"),
        INSTRUCTIONS("instructions"),
        CACHE_REFERENCES("cache-references"),
        CACHE_MISSES("cache-misses"),
        BRANCHES("branches"),
        BRANCH_MISSES("branch-misses"),
        BUS_CYCLES("bus-cycles"),
        L1_DCACHE_LOAD_MISSES("L1-dcache-load-misses"),
        LLC_LOAD_MISSES("LLC-load-misses"),
        DTLB_LOAD_MISSES("dTLB-load-misses"),
        MEM_BREAKPOINT("mem-breakpoint"),
        TRACE_TRACEPOINT("trace-tracepoint");

        private String internalName;

        private Event(String internalName) {
            this.internalName = internalName;
        }

        public String getInternalName() {
            return this.internalName;
        }

        public static Event fromInternalName(String name) {
            for (Event event : Event.values()) {
                if (!event.getInternalName().equalsIgnoreCase(name)) continue;
                return event;
            }
            return null;
        }
    }
}

