/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.server.http;

import java.util.HashMap;
import org.apache.hadoop.hdds.server.http.HttpRequestLogAppender;
import org.apache.hadoop.ozone.shaded.org.apache.commons.logging.Log;
import org.apache.hadoop.ozone.shaded.org.apache.commons.logging.LogConfigurationException;
import org.apache.hadoop.ozone.shaded.org.apache.commons.logging.LogFactory;
import org.apache.hadoop.ozone.shaded.org.apache.commons.logging.impl.Log4JLogger;
import org.apache.log4j.Appender;
import org.eclipse.jetty.server.AsyncRequestLogWriter;
import org.eclipse.jetty.server.CustomRequestLog;
import org.eclipse.jetty.server.RequestLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpRequestLog {
    public static final Logger LOG = LoggerFactory.getLogger(HttpRequestLog.class);
    private static final HashMap<String, String> SERVER_TO_COMPONENT = new HashMap();

    private HttpRequestLog() {
    }

    public static RequestLog getRequestLog(String name) {
        boolean isLog4JLogger;
        String lookup = SERVER_TO_COMPONENT.get(name);
        if (lookup != null) {
            name = lookup;
        }
        String loggerName = "http.requests." + name;
        String appenderName = name + "requestlog";
        Log logger = LogFactory.getLog(loggerName);
        try {
            isLog4JLogger = logger instanceof Log4JLogger;
        }
        catch (NoClassDefFoundError err) {
            LOG.debug("Could not load Log4JLogger class", (Throwable)err);
            isLog4JLogger = false;
        }
        if (isLog4JLogger) {
            Log4JLogger httpLog4JLog = (Log4JLogger)logger;
            org.apache.log4j.Logger httpLogger = httpLog4JLog.getLogger();
            Appender appender = null;
            try {
                appender = httpLogger.getAppender(appenderName);
            }
            catch (LogConfigurationException e) {
                LOG.warn("Http request log for {} could not be created", (Object)loggerName);
                throw e;
            }
            if (appender == null) {
                LOG.info("Http request log for {} is not defined", (Object)loggerName);
                return null;
            }
            if (appender instanceof HttpRequestLogAppender) {
                HttpRequestLogAppender requestLogAppender = (HttpRequestLogAppender)appender;
                AsyncRequestLogWriter logWriter = new AsyncRequestLogWriter();
                logWriter.setFilename(requestLogAppender.getFilename());
                logWriter.setRetainDays(requestLogAppender.getRetainDays());
                return new CustomRequestLog((RequestLog.Writer)logWriter, "%{client}a - %u %t \"%r\" %s %O \"%{Referer}i\" \"%{User-Agent}i\"");
            }
            LOG.warn("Jetty request log for {} was of the wrong class", (Object)loggerName);
            return null;
        }
        LOG.warn("Jetty request log can only be enabled using Log4j");
        return null;
    }

    static {
        SERVER_TO_COMPONENT.put("cluster", "resourcemanager");
        SERVER_TO_COMPONENT.put("hdfs", "namenode");
        SERVER_TO_COMPONENT.put("node", "nodemanager");
    }
}

