/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.security.x509.keys;

import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.apache.hadoop.hdds.security.x509.SecurityConfig;
import org.apache.hadoop.hdds.security.x509.exceptions.CertificateException;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.ASN1Sequence;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.ASN1Set;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.pkcs.Attribute;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.x500.X500Name;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.x509.Extensions;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.pkcs.PKCS10CertificationRequest;

public final class SecurityUtil {
    private static final String DISTINGUISHED_NAME_FORMAT = "CN=%s,OU=%s,O=%s";

    private SecurityUtil() {
    }

    public static String getDistinguishedNameFormat() {
        return DISTINGUISHED_NAME_FORMAT;
    }

    public static X500Name getDistinguishedName(String subject, String scmID, String clusterID) {
        return new X500Name(String.format(SecurityUtil.getDistinguishedNameFormat(), subject, scmID, clusterID));
    }

    public static Extensions getPkcs9Extensions(PKCS10CertificationRequest csr) throws CertificateException {
        ASN1Set pkcs9ExtReq = SecurityUtil.getPkcs9ExtRequest(csr);
        Object extReqElement = pkcs9ExtReq.getObjects().nextElement();
        if (extReqElement instanceof Extensions) {
            return (Extensions)extReqElement;
        }
        if (extReqElement instanceof ASN1Sequence) {
            return Extensions.getInstance((ASN1Sequence)extReqElement);
        }
        throw new CertificateException("Unknown element type :" + extReqElement.getClass().getSimpleName());
    }

    public static ASN1Set getPkcs9ExtRequest(PKCS10CertificationRequest csr) throws CertificateException {
        for (Attribute attr : csr.getAttributes()) {
            ASN1ObjectIdentifier oid = attr.getAttrType();
            if (!oid.equals(PKCSObjectIdentifiers.pkcs_9_at_extensionRequest)) continue;
            return attr.getAttrValues();
        }
        throw new CertificateException("No PKCS#9 extension found in CSR");
    }

    public static PrivateKey getPrivateKey(byte[] encodedKey, SecurityConfig secureConfig) {
        PrivateKey pvtKey = null;
        if (encodedKey == null || encodedKey.length == 0) {
            return null;
        }
        try {
            KeyFactory kf = null;
            kf = KeyFactory.getInstance(secureConfig.getKeyAlgo(), secureConfig.getProvider());
            pvtKey = kf.generatePrivate(new PKCS8EncodedKeySpec(encodedKey));
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException | InvalidKeySpecException e) {
            return null;
        }
        return pvtKey;
    }

    public static PublicKey getPublicKey(byte[] encodedKey, SecurityConfig secureConfig) {
        PublicKey key = null;
        if (encodedKey == null || encodedKey.length == 0) {
            return null;
        }
        try {
            KeyFactory kf = null;
            kf = KeyFactory.getInstance(secureConfig.getKeyAlgo(), secureConfig.getProvider());
            key = kf.generatePublic(new X509EncodedKeySpec(encodedKey));
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException | InvalidKeySpecException e) {
            return null;
        }
        return key;
    }
}

