/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.security.x509.certificate.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.hdds.security.exception.SCMSecurityException;
import org.apache.hadoop.hdds.security.x509.SecurityConfig;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.cert.X509CRLHolder;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.cert.jcajce.JcaX509CRLConverter;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CRLCodec {
    private static final Logger LOG = LoggerFactory.getLogger(CRLCodec.class);
    private static final JcaX509CRLConverter CRL_CONVERTER = new JcaX509CRLConverter();
    private final SecurityConfig securityConfig;
    private final Path location;
    private final Set<PosixFilePermission> permissionSet = Stream.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE).collect(Collectors.toSet());

    public CRLCodec(SecurityConfig securityConfig) {
        this.securityConfig = securityConfig;
        this.location = securityConfig.getCertificateLocation("scm");
    }

    public static X509CRL getX509CRL(X509CRLHolder holder) throws CRLException {
        return CRL_CONVERTER.getCRL(holder);
    }

    public static String getPEMEncodedString(X509CRLHolder holder) throws SCMSecurityException {
        LOG.trace("Getting PEM version of a CRL.");
        try {
            return CRLCodec.getPEMEncodedString(CRLCodec.getX509CRL(holder));
        }
        catch (CRLException exp) {
            throw new SCMSecurityException(exp);
        }
    }

    public static String getPEMEncodedString(X509CRL holder) throws SCMSecurityException {
        try {
            StringWriter stringWriter = new StringWriter();
            try (JcaPEMWriter pemWriter = new JcaPEMWriter(stringWriter);){
                pemWriter.writeObject(holder);
            }
            return stringWriter.toString();
        }
        catch (IOException e) {
            throw new SCMSecurityException("PEM Encoding failed for CRL." + holder.getIssuerDN().toString(), e);
        }
    }

    public static X509CRL getX509CRL(String pemEncodedString) throws CRLException, CertificateException, IOException {
        CertificateFactory fact = CertificateFactory.getInstance("X.509");
        try (InputStream input = IOUtils.toInputStream((String)pemEncodedString, (Charset)StandardCharsets.UTF_8);){
            X509CRL x509CRL = (X509CRL)fact.generateCRL(input);
            return x509CRL;
        }
    }

    public Path getLocation() {
        return this.location;
    }

    public void writeCRL(X509CRL crl) throws IOException {
        String pem = CRLCodec.getPEMEncodedString(crl);
        this.writeCRL(this.location.toAbsolutePath(), this.securityConfig.getCrlName(), pem, false);
    }

    public void writeCRL(X509CRLHolder crlHolder, String fileName, boolean overwrite) throws IOException {
        String pem = CRLCodec.getPEMEncodedString(crlHolder);
        this.writeCRL(this.location.toAbsolutePath(), fileName, pem, overwrite);
    }

    public synchronized void writeCRL(Path basePath, String fileName, String pemCRLString, boolean force) throws IOException {
        File crlFile = Paths.get(basePath.toString(), fileName).toFile();
        if (crlFile.exists() && !force) {
            throw new SCMSecurityException("Specified CRL file already exists.Please use force option if you want to overwrite it.");
        }
        if (!basePath.toFile().exists() && !basePath.toFile().mkdirs()) {
            LOG.error("Unable to create file path. Path: {}", (Object)basePath);
            throw new IOException("Creation of the directories failed." + basePath.toString());
        }
        try (FileOutputStream file = new FileOutputStream(crlFile);){
            IOUtils.write((String)pemCRLString, (OutputStream)file, (Charset)StandardCharsets.UTF_8);
        }
        Files.setPosixFilePermissions(crlFile.toPath(), this.permissionSet);
    }
}

