/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.security.x509.certificate.client;

import java.io.InputStream;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertStore;
import java.security.cert.X509Certificate;
import java.util.List;
import org.apache.hadoop.hdds.security.x509.certificates.utils.CertificateSignRequest;
import org.apache.hadoop.hdds.security.x509.exceptions.CertificateException;

public interface CertificateClient {
    public PrivateKey getPrivateKey();

    public PublicKey getPublicKey();

    public X509Certificate getCertificate(String var1) throws CertificateException;

    public X509Certificate getCertificate();

    public X509Certificate getCACertificate();

    public boolean verifyCertificate(X509Certificate var1);

    public byte[] signDataStream(InputStream var1) throws CertificateException;

    public byte[] signData(byte[] var1) throws CertificateException;

    public boolean verifySignature(InputStream var1, byte[] var2, X509Certificate var3) throws CertificateException;

    public boolean verifySignature(byte[] var1, byte[] var2, X509Certificate var3) throws CertificateException;

    public CertificateSignRequest.Builder getCSRBuilder() throws CertificateException;

    public X509Certificate queryCertificate(String var1);

    public void storeCertificate(String var1, boolean var2) throws CertificateException;

    public void storeCertificate(String var1, boolean var2, boolean var3) throws CertificateException;

    public void storeTrustChain(CertStore var1) throws CertificateException;

    public void storeTrustChain(List<X509Certificate> var1) throws CertificateException;

    public InitResponse init() throws CertificateException;

    public static enum InitResponse {
        SUCCESS,
        FAILURE,
        GETCERT,
        RECOVER;

    }
}

