/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.security.x509.certificate.authority;

import java.io.IOException;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.util.Date;
import java.util.concurrent.CompletableFuture;
import org.apache.hadoop.hdds.security.exception.SCMSecurityException;
import org.apache.hadoop.hdds.security.x509.SecurityConfig;
import org.apache.hadoop.hdds.security.x509.certificate.authority.BaseApprover;
import org.apache.hadoop.hdds.security.x509.certificate.authority.PKIProfiles.PKIProfile;
import org.apache.hadoop.hdds.security.x509.keys.SecurityUtil;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.x500.X500Name;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.x500.style.BCStyle;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.cert.X509CertificateHolder;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.cert.X509v3CertificateBuilder;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.crypto.params.RSAKeyParameters;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.crypto.util.PublicKeyFactory;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.operator.ContentSigner;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.operator.OperatorCreationException;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.operator.bc.BcRSAContentSignerBuilder;
import org.apache.hadoop.ozone.shaded.org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.apache.hadoop.util.Time;

public class DefaultApprover
extends BaseApprover {
    public DefaultApprover(PKIProfile pkiProfile, SecurityConfig config) {
        super(pkiProfile, config);
    }

    @Override
    public X509CertificateHolder sign(SecurityConfig config, PrivateKey caPrivate, X509CertificateHolder caCertificate, Date validFrom, Date validTill, PKCS10CertificationRequest certificationRequest, String scmId, String clusterId) throws IOException, OperatorCreationException {
        RSAKeyParameters rsa;
        AlgorithmIdentifier sigAlgId = new DefaultSignatureAlgorithmIdentifierFinder().find(config.getSignatureAlgo());
        AlgorithmIdentifier digAlgId = new DefaultDigestAlgorithmIdentifierFinder().find(sigAlgId);
        AsymmetricKeyParameter asymmetricKP = PrivateKeyFactory.createKey(caPrivate.getEncoded());
        SubjectPublicKeyInfo keyInfo = certificationRequest.getSubjectPublicKeyInfo();
        X500Name x500Name = certificationRequest.getSubject();
        String csrScmId = x500Name.getRDNs(BCStyle.OU)[0].getFirst().getValue().toASN1Primitive().toString();
        String csrClusterId = x500Name.getRDNs(BCStyle.O)[0].getFirst().getValue().toASN1Primitive().toString();
        if (!scmId.equals(csrScmId) || !clusterId.equals(csrClusterId)) {
            if (csrScmId.equalsIgnoreCase("null") && csrClusterId.equalsIgnoreCase("null")) {
                String cn = x500Name.getRDNs(BCStyle.CN)[0].getFirst().getValue().toASN1Primitive().toString();
                x500Name = SecurityUtil.getDistinguishedName(cn, scmId, clusterId);
            } else {
                throw new SCMSecurityException("ScmId and ClusterId in CSR subject are incorrect.");
            }
        }
        if ((rsa = (RSAKeyParameters)PublicKeyFactory.createKey(keyInfo)).getModulus().bitLength() < config.getSize()) {
            throw new SCMSecurityException("Key size is too small in certificate signing request");
        }
        X509v3CertificateBuilder certificateGenerator = new X509v3CertificateBuilder(caCertificate.getSubject(), BigInteger.valueOf(Time.monotonicNowNanos()), validFrom, validTill, x500Name, keyInfo);
        ContentSigner sigGen = new BcRSAContentSignerBuilder(sigAlgId, digAlgId).build(asymmetricKP);
        return certificateGenerator.build(sigGen);
    }

    @Override
    public CompletableFuture<X509CertificateHolder> inspectCSR(String csr) throws IOException {
        return super.inspectCSR(csr);
    }

    @Override
    public CompletableFuture<X509CertificateHolder> inspectCSR(PKCS10CertificationRequest csr) {
        return super.inspectCSR(csr);
    }
}

